/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.threading;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class TaskScheduler<T> {
    protected final boolean cancelMayInterruptIfRunning;
    protected final ScheduledExecutorService executor;
    protected final AtomicReference<ScheduledFuture<?>> taskRef = new AtomicReference();

    public TaskScheduler() {
        this(false);
    }

    public TaskScheduler(boolean cancelMayInterruptIfRunning) {
        this.cancelMayInterruptIfRunning = cancelMayInterruptIfRunning;
        this.executor = Executors.newSingleThreadScheduledExecutor();
    }

    public TaskScheduler(boolean cancelMayInterruptIfRunning, ThreadFactory threadFactory) {
        this.cancelMayInterruptIfRunning = cancelMayInterruptIfRunning;
        this.executor = Executors.newSingleThreadScheduledExecutor(threadFactory);
    }

    public TaskScheduler(boolean cancelMayInterruptIfRunning, ScheduledExecutorService executor) {
        this.cancelMayInterruptIfRunning = cancelMayInterruptIfRunning;
        this.executor = executor;
    }

    public void scheduleAtFixedRate(Task<T> task, long initialDelay, long period, TimeUnit unit) {
        this.cancel();
        this.taskRef.set(this.executor.scheduleAtFixedRate(task, initialDelay, period, unit));
    }

    public void scheduleWithFixedDelay(Task<T> task, long initialDelay, long delay, TimeUnit unit) {
        this.cancel();
        this.taskRef.set(this.executor.scheduleWithFixedDelay(task, initialDelay, delay, unit));
    }

    public void cancel() {
        ScheduledFuture t = this.taskRef.getAndSet(null);
        if (t != null) {
            t.cancel(this.cancelMayInterruptIfRunning);
        }
    }

    public void shutdownNow() {
        this.executor.shutdownNow();
    }

    public boolean hasTask() {
        return this.taskRef.get() != null;
    }

    public static abstract class Task<T>
    implements Runnable {
        protected final T data;

        public Task() {
            this(null);
        }

        public Task(T data) {
            this.data = data;
        }
    }
}

