/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.threading;

import com.appslandia.common.threading.MutexService;
import com.appslandia.common.utils.AssertUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public abstract class TaskMutexService<K>
extends MutexService<K> {
    protected abstract ExecutorService getExecutorService();

    public <V> Future<V> execute(final K mutexKey, final Callable<V> task) throws Exception {
        this.initialize();
        AssertUtils.assertNotNull(mutexKey);
        return this.getExecutorService().submit(new Callable<V>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V call() throws Exception {
                Object object = TaskMutexService.this.getMutex(mutexKey);
                synchronized (object) {
                    return task.call();
                }
            }
        });
    }

    public void execute(final K mutexKey, final Runnable task) throws Exception {
        this.initialize();
        AssertUtils.assertNotNull(mutexKey);
        this.getExecutorService().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TaskMutexService.this.getMutex(mutexKey);
                synchronized (object) {
                    task.run();
                }
            }
        });
    }

    public <V> Future<V> execute(final K mutexKey, final Runnable task, V result) throws Exception {
        this.initialize();
        AssertUtils.assertNotNull(mutexKey);
        return this.getExecutorService().submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = TaskMutexService.this.getMutex(mutexKey);
                synchronized (object) {
                    task.run();
                }
            }
        }, result);
    }
}

