/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.record;

import com.appslandia.common.record.FieldValidator;
import com.appslandia.common.utils.AssertUtils;
import java.lang.reflect.Array;
import java.util.Objects;

public class ValidValuesValidator
implements FieldValidator {
    public static final String ERROR_MSG_KEY = ValidValuesValidator.class.getName() + ".message";

    @Override
    public FieldValidator.FieldError validate(Object value, Object constraintArgs) {
        AssertUtils.assertNotNull(constraintArgs, "constraintArgs is required.");
        AssertUtils.assertTrue(constraintArgs.getClass().isArray(), "constraintArgs must be an array.");
        if (value == null) {
            return null;
        }
        int len = Array.getLength(constraintArgs);
        for (int i = 0; i < len; ++i) {
            Object validValue = Array.get(constraintArgs, i);
            if (!Objects.equals(value, validValue)) continue;
            return null;
        }
        return new FieldValidator.FieldError(ERROR_MSG_KEY, constraintArgs);
    }
}

