/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.record;

import com.appslandia.common.record.FieldValidator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Pattern;

public class PatternValidator
implements FieldValidator {
    static final ConcurrentMap<String, Pattern> PATTERNS = new ConcurrentHashMap<String, Pattern>();
    public static final String ERROR_MSG_KEY = PatternValidator.class.getName() + ".message";

    @Override
    public FieldValidator.FieldError validate(Object value, Object constraintArgs) {
        if (value == null) {
            return null;
        }
        String strValue = (String)value;
        if (PatternValidator.getPattern((String)constraintArgs).matcher(strValue).matches()) {
            return null;
        }
        return new FieldValidator.FieldError(ERROR_MSG_KEY, constraintArgs);
    }

    private static Pattern getPattern(String pattern) {
        return PATTERNS.computeIfAbsent(pattern, p -> Pattern.compile(pattern, 2));
    }
}

