/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.record;

import com.appslandia.common.record.BitValuesValidator;
import com.appslandia.common.record.Field;
import com.appslandia.common.record.FieldValidator;
import com.appslandia.common.record.MaxLengthValidator;
import com.appslandia.common.record.MinLengthValidator;
import com.appslandia.common.record.PatternValidator;
import com.appslandia.common.record.Record;
import com.appslandia.common.record.RequiredValidator;
import com.appslandia.common.record.Table;
import com.appslandia.common.record.ValidValuesValidator;
import com.appslandia.common.record.ValidatorException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldValidators {
    final Map<String, FieldValidator> validators = new HashMap<String, FieldValidator>();

    public FieldValidators() {
        this.initialize();
    }

    protected void initialize() {
        this.putValidator("required", new RequiredValidator());
        this.putValidator("pattern", new PatternValidator());
        this.putValidator("maxLength", new MaxLengthValidator());
        this.putValidator("minLength", new MinLengthValidator());
        this.putValidator("bitValues", new BitValuesValidator());
        this.putValidator("validValues", new ValidValuesValidator());
    }

    public FieldValidator getValidator(String name) throws IllegalArgumentException {
        FieldValidator validator = this.validators.get(name);
        if (validator == null) {
            throw new IllegalArgumentException("Validator is required (name=" + name + ")");
        }
        return validator;
    }

    public void putValidator(String name, FieldValidator validator) {
        this.validators.put(name, validator);
    }

    public void validateField(Field field, Object value, List<FieldValidator.FieldError> errors) {
        for (Map.Entry<String, Object> constraint : field.getConstraints().entrySet()) {
            FieldValidator.FieldError error = this.getValidator(constraint.getKey()).validate(value, constraint.getValue());
            if (error == null) continue;
            errors.add(error);
        }
    }

    public void validateRecord(Record record, Table table, Callback callback) {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            this.validateField(field, record.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            callback.onError(field.getName(), errors);
        }
    }

    public void validateKey(Record key, Table table, Callback callback) {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            this.validateField(field, key.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            callback.onError(field.getName(), errors);
        }
    }

    public void validateRecord(Record record, Table table) throws ValidatorException {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            this.validateField(field, record.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            throw new ValidatorException("field=" + field.getName() + ", errors=" + errors);
        }
    }

    public void validateKey(Record key, Table table) throws ValidatorException {
        ArrayList<FieldValidator.FieldError> errors = new ArrayList<FieldValidator.FieldError>(2);
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            this.validateField(field, key.get(field.getName()), errors);
            if (errors.isEmpty()) continue;
            throw new ValidatorException("field=" + field.getName() + ", errors=" + errors);
        }
    }

    public static interface Callback {
        public void onError(String var1, List<FieldValidator.FieldError> var2);
    }
}

