/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.record;

import com.appslandia.common.jdbc.JdbcUtils;
import com.appslandia.common.jdbc.ResultSetHandler;
import com.appslandia.common.jdbc.ResultSetImpl;
import com.appslandia.common.jdbc.ResultSetMapper;
import com.appslandia.common.jdbc.Sql;
import com.appslandia.common.jdbc.StatementImpl;
import com.appslandia.common.record.Field;
import com.appslandia.common.record.Record;
import com.appslandia.common.record.RecordUtils;
import com.appslandia.common.record.Table;
import com.appslandia.common.threading.ThreadLocalStorage;
import com.appslandia.common.utils.ObjectUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;

public class DbManager
implements AutoCloseable {
    private Connection conn;
    private Map<String, StatementImpl> tableStats = new LinkedHashMap<String, StatementImpl>();
    private boolean closed = false;
    private static final ThreadLocalStorage<DataSource> DS_HOLDER = new ThreadLocalStorage();

    public DbManager() throws SQLException {
        this(DbManager.getDataSource());
    }

    public DbManager(DataSource dataSource) throws SQLException {
        this.conn = dataSource.getConnection();
    }

    public Connection getConnection() {
        return this.conn;
    }

    protected void setParameter(StatementImpl stat, String parameterName, Object val, int sqlType) throws SQLException {
        if (val == null) {
            if (sqlType > 0) {
                stat.setNull(parameterName, sqlType);
            } else {
                stat.setObject(parameterName, null);
            }
        } else if (sqlType > 0) {
            stat.setObject(parameterName, val, sqlType);
        } else {
            stat.setObject(parameterName, val);
        }
    }

    protected void setParameters(StatementImpl stat, Map<String, Object> params) throws SQLException {
        for (Map.Entry<String, Object> param : params.entrySet()) {
            stat.setObject(param.getKey(), param.getValue());
        }
    }

    public Object insert(Record record, Table table) throws SQLException {
        return this.insert(record, table, false);
    }

    public void insertBatch(Record record, Table table) throws SQLException {
        this.insert(record, table, true);
    }

    protected Object insert(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatementImpl stat = this.tableStats.get(table.getInsertSql().getName());
        if (stat == null) {
            stat = new StatementImpl(this.conn, table.getInsertSql(), table.getAutoKey() != null);
            this.tableStats.put(table.getInsertSql().getName(), stat);
        }
        for (Field field : table.getFields()) {
            if (field.isAutoKey()) continue;
            Object val = record.get(field.getName());
            this.setParameter(stat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = stat.executeUpdate();
            if (table.getAutoKey() != null) {
                try (ResultSet rs = stat.getGeneratedKeys();){
                    if (rs.next()) {
                        Object generatedKey = rs.getObject(1);
                        record.set(table.getAutoKey().getName(), generatedKey);
                        Object object = generatedKey;
                        return object;
                    }
                }
            }
        } else {
            this.assertNotAutoCommit();
            stat.addBatch();
        }
        return rowAffected;
    }

    public int update(Record record, Table table) throws SQLException {
        return this.update(record, table, false);
    }

    public void updateBatch(Record record, Table table) throws SQLException {
        this.update(record, table, true);
    }

    protected int update(Record record, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatementImpl stat = this.tableStats.get(table.getUpdateSql().getName());
        if (stat == null) {
            stat = new StatementImpl(this.conn, table.getUpdateSql());
            this.tableStats.put(table.getUpdateSql().getName(), stat);
        }
        for (Field field : table.getFields()) {
            if (!field.isKey() && !field.isUpdatable()) continue;
            Object val = record.get(field.getName());
            this.setParameter(stat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = stat.executeUpdate();
        } else {
            this.assertNotAutoCommit();
            stat.addBatch();
        }
        return rowAffected;
    }

    public int delete(Record key, Table table) throws SQLException {
        return this.delete(key, table, false);
    }

    public void deleteBatch(Record key, Table table) throws SQLException {
        this.delete(key, table, true);
    }

    protected int delete(Record key, Table table, boolean addBatch) throws SQLException {
        this.assertNotClosed();
        StatementImpl stat = this.tableStats.get(table.getDeleteSql().getName());
        if (stat == null) {
            stat = new StatementImpl(this.conn, table.getDeleteSql());
            this.tableStats.put(table.getDeleteSql().getName(), stat);
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            this.setParameter(stat, field.getName(), val, field.getSqlType());
        }
        int rowAffected = -1;
        if (!addBatch) {
            rowAffected = stat.executeUpdate();
        } else {
            this.assertNotAutoCommit();
            stat.addBatch();
        }
        return rowAffected;
    }

    public Record getRecord(Record key, Table table) throws SQLException {
        this.assertNotClosed();
        StatementImpl stat = this.tableStats.get(table.getGetSql().getName());
        if (stat == null) {
            stat = new StatementImpl(this.conn, table.getGetSql());
            this.tableStats.put(table.getGetSql().getName(), stat);
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            this.setParameter(stat, field.getName(), val, field.getSqlType());
        }
        try (ResultSetImpl rs = stat.executeQuery();){
            String[] columnLabels = JdbcUtils.getColumnLabels(rs);
            Record record = JdbcUtils.executeSingle(rs, r -> RecordUtils.toRecord(r, columnLabels));
            return record;
        }
    }

    public boolean exists(Record key, Table table) throws SQLException {
        this.assertNotClosed();
        StatementImpl stat = this.tableStats.get(table.getExistsSql().getName());
        if (stat == null) {
            stat = new StatementImpl(this.conn, table.getExistsSql());
            this.tableStats.put(table.getExistsSql().getName(), stat);
        }
        for (Field field : table.getFields()) {
            if (!field.isKey()) continue;
            Object val = key.get(field.getName());
            this.setParameter(stat, field.getName(), val, field.getSqlType());
        }
        Number count = (Number)stat.executeScalar();
        if (count == null) {
            return false;
        }
        if (count.longValue() > 1L) {
            throw new IllegalStateException("Duplicate key.");
        }
        return true;
    }

    public List<Record> executeList(String sql) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            List<Record> list;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                String[] columnLabels = JdbcUtils.getColumnLabels(rs);
                list = JdbcUtils.executeList(rs, r -> RecordUtils.toRecord(r, columnLabels), new ArrayList());
            }
            return list;
        }
    }

    public <T> List<Record> executeList(String pSql, Map<String, Object> params) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            List<Record> list;
            block11: {
                this.setParameters(stat, params);
                ResultSetImpl rs = stat.executeQuery();
                try {
                    String[] columnLabels = JdbcUtils.getColumnLabels(rs);
                    list = JdbcUtils.executeList(rs, r -> RecordUtils.toRecord(r, columnLabels), new ArrayList());
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list;
        }
    }

    public Record executeSingle(String sql) throws SQLException {
        this.assertNotClosed();
        return this.executeSingle(sql, (ResultSetImpl rs) -> {
            String[] columnLabels = JdbcUtils.getColumnLabels(rs);
            return RecordUtils.toRecord(rs, columnLabels);
        });
    }

    public Record executeSingle(String pSql, Map<String, Object> params) throws SQLException {
        this.assertNotClosed();
        return this.executeSingle(pSql, params, rs -> {
            String[] columnLabels = JdbcUtils.getColumnLabels(rs);
            return RecordUtils.toRecord(rs, columnLabels);
        });
    }

    public int executeUpdate(String sql) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            int n = stat.executeUpdate(sql);
            return n;
        }
    }

    public int executeUpdate(String pSql, Map<String, Object> params) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            this.setParameters(stat, params);
            int n = stat.executeUpdate();
            return n;
        }
    }

    public <K, V> Map<K, V> executeMap(String sql, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper) throws SQLException {
        return this.executeMap(sql, keyMapper, valueMapper, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            Map<K, V> map2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                map2 = JdbcUtils.executeMap(rs, keyMapper, valueMapper, map);
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String pSql, Map<String, Object> params, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper) throws SQLException {
        return this.executeMap(pSql, params, keyMapper, valueMapper, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String pSql, Map<String, Object> params, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            Map<K, V> map2;
            block11: {
                this.setParameters(stat, params);
                ResultSetImpl rs = stat.executeQuery();
                try {
                    map2 = JdbcUtils.executeMap(rs, keyMapper, valueMapper, map);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String sql, String keyColumn, String valueColumn) throws SQLException {
        return this.executeMap(sql, keyColumn, valueColumn, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            Map<K, V> map2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                map2 = JdbcUtils.executeMap((ResultSet)rs, keyColumn, valueColumn, map);
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String pSql, Map<String, Object> params, String keyColumn, String valueColumn) throws SQLException {
        return this.executeMap(pSql, params, keyColumn, valueColumn, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String pSql, Map<String, Object> params, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            Map<K, V> map2;
            block11: {
                this.setParameters(stat, params);
                ResultSetImpl rs = stat.executeQuery();
                try {
                    map2 = JdbcUtils.executeMap((ResultSet)rs, keyColumn, valueColumn, map);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return map2;
        }
    }

    public <T> List<T> executeList(String sql, ResultSetMapper<T> mapper) throws SQLException {
        return this.executeList(sql, mapper, new ArrayList());
    }

    public <T> List<T> executeList(String sql, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            List<T> list2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                list2 = JdbcUtils.executeList(rs, mapper, list);
            }
            return list2;
        }
    }

    public <T> List<T> executeList(String pSql, Map<String, Object> params, ResultSetMapper<T> mapper) throws SQLException {
        return this.executeList(pSql, params, mapper, new ArrayList());
    }

    public <T> List<T> executeList(String pSql, Map<String, Object> params, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            List<T> list2;
            block11: {
                this.setParameters(stat, params);
                ResultSetImpl rs = stat.executeQuery();
                try {
                    list2 = JdbcUtils.executeList(rs, mapper, list);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list2;
        }
    }

    public <T> T executeSingle(String sql, ResultSetMapper<T> mapper) throws SQLException {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();){
            T t;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                t = JdbcUtils.executeSingle(rs, mapper);
            }
            return t;
        }
    }

    public <T> T executeSingle(String pSql, Map<String, Object> params, ResultSetMapper<T> mapper) throws SQLException {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            T t;
            block11: {
                this.setParameters(stat, params);
                ResultSetImpl rs = stat.executeQuery();
                try {
                    t = JdbcUtils.executeSingle(rs, mapper);
                    if (rs == null) break block11;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return t;
        }
    }

    public <T> T executeScalar(String sql) throws SQLException {
        return (T)this.executeSingle(sql, (ResultSetImpl rs) -> ObjectUtils.cast(rs.getObject(1)));
    }

    public <T> T executeScalar(String pSql, Map<String, Object> params) throws SQLException {
        return (T)this.executeSingle(pSql, params, rs -> ObjectUtils.cast(rs.getObject(1)));
    }

    public void executeQuery(String sql, ResultSetHandler handler) throws Exception {
        this.assertNotClosed();
        try (Statement stat = this.conn.createStatement();
             ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
            while (rs.next()) {
                handler.handle(rs);
            }
        }
    }

    public void executeQuery(String pSql, Map<String, Object> params, ResultSetHandler handler) throws Exception {
        this.assertNotClosed();
        try (StatementImpl stat = new StatementImpl(this.conn, new Sql(pSql));){
            this.setParameters(stat, params);
            try (ResultSetImpl rs = stat.executeQuery();){
                while (rs.next()) {
                    handler.handle(rs);
                }
            }
        }
    }

    public void executeBatch() throws SQLException {
        this.assertNotClosed();
        this.assertNotAutoCommit();
        for (StatementImpl stat : this.tableStats.values()) {
            stat.executeBatch();
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.assertNotClosed();
        this.conn.setAutoCommit(autoCommit);
    }

    public boolean getAutoCommit() throws SQLException {
        this.assertNotClosed();
        return this.conn.getAutoCommit();
    }

    public void commit() throws SQLException {
        this.assertNotClosed();
        this.assertNotAutoCommit();
        this.conn.commit();
    }

    public void rollback() throws SQLException {
        this.assertNotClosed();
        this.assertNotAutoCommit();
        this.conn.rollback();
    }

    protected void assertNotAutoCommit() throws SQLException {
        if (this.conn.getAutoCommit()) {
            throw new SQLException("auto commit must be disabled.");
        }
    }

    protected void assertNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException(this + " closed.");
        }
    }

    private void closeStatements() throws SQLException {
        ArrayList<StatementImpl> stats = new ArrayList<StatementImpl>(this.tableStats.values());
        for (int i = stats.size() - 1; i >= 0; --i) {
            ((StatementImpl)stats.get(i)).close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closeStatements();
            if (!this.conn.getAutoCommit()) {
                this.conn.setAutoCommit(true);
            }
            this.conn.close();
            this.closed = true;
        }
    }

    public static DataSource getDataSource() throws IllegalStateException {
        DataSource ds = DS_HOLDER.get();
        if (ds == null) {
            throw new IllegalStateException("No current DataSource found in the current thread.");
        }
        return ds;
    }

    public static void setDataSource(DataSource ds) {
        DS_HOLDER.set(ds);
    }
}

