/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.objects.ObjectDefinition;
import com.appslandia.common.objects.ObjectScope;
import java.util.function.Function;

public class ObjectInstance {
    final ObjectDefinition definition;
    private volatile Object instance;
    final Function<ObjectDefinition, Object> factory;
    final Object mutex = new Object();

    public ObjectInstance(ObjectDefinition definition, Function<ObjectDefinition, Object> factory) {
        this.definition = definition;
        this.factory = factory;
    }

    public ObjectDefinition getDefinition() {
        return this.definition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInstance() {
        if (this.definition.getScope() == ObjectScope.PROTOTYPE) {
            return this.factory.apply(this.definition);
        }
        Object obj = this.instance;
        if (obj == null) {
            Object object = this.mutex;
            synchronized (object) {
                obj = this.instance;
                if (obj == null) {
                    this.instance = obj = this.factory.apply(this.definition);
                }
            }
        }
        return obj;
    }

    public void clearInstance() {
        this.instance = null;
    }
}

