/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.objects.ObjectProducer;
import com.appslandia.common.objects.ObjectScope;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ReflectionUtils;
import com.appslandia.common.utils.ValueUtils;
import java.lang.annotation.Annotation;
import java.util.Arrays;

public class ObjectDefinition
extends InitializeObject {
    private Class<?>[] types;
    private Annotation[] qualifiers;
    private ObjectScope scope;
    private Class<?> implClass;
    private ObjectProducer<?> producer;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.types);
        AssertUtils.assertNotNull(this.scope);
        AssertUtils.assertTrue(this.implClass != null || this.producer != null);
        this.qualifiers = ValueUtils.valueOrAlt(this.qualifiers, ReflectionUtils.EMPTY_ANNOTATIONS);
    }

    public boolean hasType(Class<?> type) {
        this.initialize();
        return Arrays.stream(this.types).anyMatch(t -> t == type);
    }

    public Class<?>[] getTypes() {
        this.initialize();
        return (Class[])this.types.clone();
    }

    public ObjectDefinition setTypes(Class<?>[] types) {
        this.assertNotInitialized();
        this.types = types;
        return this;
    }

    public Annotation[] getQualifiers() {
        this.initialize();
        return this.qualifiers;
    }

    public ObjectDefinition setQualifiers(Annotation ... qualifiers) {
        this.assertNotInitialized();
        this.qualifiers = qualifiers;
        return this;
    }

    public ObjectScope getScope() {
        this.initialize();
        return this.scope;
    }

    public ObjectDefinition setScope(ObjectScope scope) {
        this.assertNotInitialized();
        this.scope = scope;
        return this;
    }

    public Class<?> getImplClass() {
        this.initialize();
        return this.implClass;
    }

    public ObjectDefinition setImplClass(Class<?> implClass) {
        this.assertNotInitialized();
        this.implClass = implClass;
        return this;
    }

    public ObjectProducer<?> getProducer() {
        this.initialize();
        return this.producer;
    }

    public ObjectDefinition setProducer(ObjectProducer<?> producer) {
        this.assertNotInitialized();
        this.producer = producer;
        return this;
    }
}

