/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.objects.AnnotationUtils;
import com.appslandia.common.objects.ObjectException;
import com.appslandia.common.objects.ObjectFactoryUtils;
import com.appslandia.common.objects.ObjectInstance;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class InstanceImpl<T>
implements Instance<T> {
    final Class<?> type;
    final Annotation[] qualifiers;
    final List<ObjectInstance> instances;

    public InstanceImpl(Class<?> type, Annotation[] qualifiers, List<ObjectInstance> instances) {
        this.type = type;
        this.qualifiers = qualifiers;
        this.instances = instances;
    }

    public int getCount() {
        return this.instances.size();
    }

    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int index = -1;

            @Override
            public T next() {
                ObjectInstance objInst = InstanceImpl.this.instances.get(++this.index);
                return ObjectUtils.cast(objInst.getInstance());
            }

            @Override
            public boolean hasNext() {
                return this.index < InstanceImpl.this.instances.size() - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public T get() {
        if (this.isUnsatisfied()) {
            throw new ObjectException("Unsatisfied dependency (type=" + this.type + ", qualifiers=" + Arrays.toString(this.qualifiers));
        }
        if (this.isAmbiguous()) {
            throw new ObjectException("Ambiguous dependency (type=" + this.type + ", qualifiers=" + Arrays.toString(this.qualifiers));
        }
        return ObjectUtils.cast(this.instances.get(0).getInstance());
    }

    public Instance<T> select(Annotation ... qualifiers) {
        if (qualifiers.length == 0) {
            return this;
        }
        Annotation[] childQualifiers = this.getChildQualifiers(qualifiers);
        ArrayList<ObjectInstance> sub = new ArrayList<ObjectInstance>();
        for (ObjectInstance objInst : this.instances) {
            if (!AnnotationUtils.hasAnnotations(objInst.definition.getQualifiers(), childQualifiers)) continue;
            sub.add(objInst);
        }
        return new InstanceImpl<T>(this.type, childQualifiers, sub);
    }

    public <U extends T> Instance<U> select(Class<U> subtype, Annotation ... qualifiers) {
        AssertUtils.assertNotNull(subtype);
        if (this.type == subtype && qualifiers.length == 0) {
            return (Instance)ObjectUtils.cast(this);
        }
        Annotation[] childQualifiers = this.getChildQualifiers(qualifiers);
        ArrayList<ObjectInstance> sub = new ArrayList<ObjectInstance>();
        for (ObjectInstance objInst : this.instances) {
            if (!AnnotationUtils.hasAnnotations(objInst.definition.getQualifiers(), childQualifiers) || !subtype.isInstance(objInst.getInstance())) continue;
            sub.add(objInst);
        }
        return new InstanceImpl<T>(subtype, childQualifiers, sub);
    }

    public <U extends T> Instance<U> select(TypeLiteral<U> subtype, Annotation ... qualifiers) {
        throw new UnsupportedOperationException();
    }

    public boolean isUnsatisfied() {
        return this.instances.isEmpty();
    }

    public boolean isAmbiguous() {
        return this.instances.size() > 1;
    }

    public void destroy(T instance) {
        AssertUtils.assertNotNull(instance);
        ObjectFactoryUtils.destroy(instance);
    }

    private Annotation[] getChildQualifiers(Annotation[] qualifiers) {
        Set<Annotation> s = CollectionUtils.toSet(new LinkedHashSet(), this.qualifiers);
        CollectionUtils.toSet(s, qualifiers);
        return s.toArray(new Annotation[s.size()]);
    }
}

