/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.objects;

import com.appslandia.common.objects.ObjectFactory;
import com.appslandia.common.objects.ObjectProducer;
import com.appslandia.common.objects.ObjectScope;
import com.appslandia.common.utils.ReflectionUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

public class AnnotationUtils {
    public static boolean equals(Annotation[] anns1, Annotation[] anns2) {
        if (anns2.length != anns1.length) {
            return false;
        }
        if (anns2.length == 0) {
            return true;
        }
        return Arrays.stream(anns2).allMatch(ann2 -> Arrays.stream(anns1).anyMatch(ann1 -> ann1.equals(ann2)));
    }

    public static boolean hasAnnotations(Annotation[] src, Annotation[] annotations) {
        if (annotations.length == 0) {
            return src.length == 0;
        }
        return Arrays.stream(annotations).allMatch(ann -> Arrays.stream(src).anyMatch(srcAnn -> srcAnn.equals(ann)));
    }

    public static Annotation[] parseQualifiers(Annotation[] annotations) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>(3);
        for (Annotation ann : annotations) {
            if (ann.annotationType().getDeclaredAnnotation(Qualifier.class) == null) continue;
            qualifiers.add(ann);
        }
        return !qualifiers.isEmpty() ? qualifiers.toArray(new Annotation[qualifiers.size()]) : ReflectionUtils.EMPTY_ANNOTATIONS;
    }

    public static Annotation[] parseQualifiers(AnnotatedElement element) {
        return AnnotationUtils.parseQualifiers(element.getDeclaredAnnotations());
    }

    public static Annotation[] parseQualifiers(ObjectProducer<?> producer) {
        Method m = ReflectionUtils.getDeclaredMethod(producer.getClass(), "produce", ObjectFactory.class);
        return AnnotationUtils.parseQualifiers(m);
    }

    public static ObjectScope parseScope(ObjectProducer<?> producer) {
        Method m = ReflectionUtils.getDeclaredMethod(producer.getClass(), "produce", ObjectFactory.class);
        return AnnotationUtils.parseScope(m);
    }

    public static ObjectScope parseScope(AnnotatedElement element) {
        if (element.getDeclaredAnnotation(ApplicationScoped.class) != null) {
            return ObjectScope.SINGLETON;
        }
        if (element.getDeclaredAnnotation(Dependent.class) != null) {
            return ObjectScope.PROTOTYPE;
        }
        if (element.getDeclaredAnnotation(SessionScoped.class) != null || element.getDeclaredAnnotation(RequestScoped.class) != null) {
            throw new IllegalArgumentException("SessionScoped/RequestScoped is unsupported.");
        }
        return ObjectScope.SINGLETON;
    }
}

