/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.mail;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.SecureProps;
import com.appslandia.common.mail.MailerMessage;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.ParseUtils;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.MimeMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class SmtpMailer
extends InitializeObject {
    protected SecureProps props;
    protected Session session;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.props, "props is required.");
        this.session = Session.getInstance((Properties)this.props);
    }

    public MailerMessage newMessage() throws AddressException {
        MailerMessage msg = new MailerMessage();
        String msgFrom = this.props.get("mail.smtp.msg.from");
        if (msgFrom != null) {
            msg.from(msgFrom);
        }
        return msg;
    }

    public void send(MailerMessage message) throws MessagingException {
        this.send(CollectionUtils.toList(new ArrayList(1), new MailerMessage[]{message}));
    }

    public void send(List<MailerMessage> messages) throws MessagingException {
        this.initialize();
        AssertUtils.assertNotNull(messages);
        try (Transport transport = this.session.getTransport("smtp");){
            String user = AssertUtils.assertNotNull(this.props.get("mail.smtp.user"), "mail.smtp.user is required.");
            String password = AssertUtils.assertNotNull(this.props.get("mail.smtp.password"), "mail.smtp.password is required.");
            transport.connect(user, password);
            String debugToEmails = null;
            if (ParseUtils.isTrueValue(this.props.get("mail.smtp.debug.enabled"))) {
                debugToEmails = AssertUtils.assertNotNull(this.props.get("mail.smtp.debug.to_emails"), "mail.smtp.debug.to_emails is required.");
            }
            for (MailerMessage mailerMessage : messages) {
                MimeMessage message = mailerMessage.toMimeMessage(this, debugToEmails);
                message.saveChanges();
                transport.sendMessage((Message)message, message.getAllRecipients());
            }
        }
    }

    public void sendAsync(MailerMessage message, Executor executor, Consumer<Exception> consumer) {
        this.sendAsync(CollectionUtils.toList(new ArrayList(1), new MailerMessage[]{message}), executor, consumer);
    }

    public void sendAsync(final List<MailerMessage> messages, Executor executor, final Consumer<Exception> consumer) {
        this.initialize();
        AssertUtils.assertNotNull(messages);
        AssertUtils.assertNotNull(executor);
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SmtpMailer.this.send(messages);
                }
                catch (Exception ex) {
                    if (consumer != null) {
                        consumer.accept(ex);
                    }
                    throw ExceptionUtils.toUncheckedException(ex);
                }
            }
        });
    }

    public SmtpMailer setProps(SecureProps props) {
        this.assertNotInitialized();
        if (props != null) {
            this.props = props.copy();
        }
        return this;
    }
}

