/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.mail;

import com.appslandia.common.mail.SmtpMailer;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.EmailUtils;
import jakarta.mail.Address;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;

public class MailerMessage {
    private Address sender;
    private List<Address> from;
    private List<Address> replyTo;
    private List<Address> to;
    private List<Address> cc;
    private List<Address> bcc;
    private String subject;
    private Object content;
    private String contentType;
    private Date sentDate;
    private Consumer<MimeMessage> msgInit;

    public MailerMessage clearFrom() {
        if (this.from != null) {
            this.from.clear();
        }
        return this;
    }

    public MailerMessage sender(String email) throws AddressException {
        this.sender = new InternetAddress(email);
        return this;
    }

    public MailerMessage sender(String email, String person) throws AddressException {
        this.sender = EmailUtils.parseAddress(email, person);
        return this;
    }

    public MailerMessage from(String email) throws AddressException {
        this.getFrom().add((Address)new InternetAddress(email));
        return this;
    }

    public MailerMessage from(String email, String person) throws AddressException {
        this.getFrom().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailerMessage replyTo(String email) throws AddressException {
        this.getReplyTo().add((Address)new InternetAddress(email));
        return this;
    }

    public MailerMessage replyTo(String email, String person) throws AddressException {
        this.getReplyTo().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailerMessage to(String email) throws AddressException {
        this.getTo().add((Address)new InternetAddress(email));
        return this;
    }

    public MailerMessage to(String email, String person) throws AddressException {
        this.getTo().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailerMessage cc(String email) throws AddressException {
        this.getCc().add((Address)new InternetAddress(email));
        return this;
    }

    public MailerMessage cc(String email, String person) throws AddressException {
        this.getCc().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailerMessage bcc(String email) throws AddressException {
        this.getBcc().add((Address)new InternetAddress(email));
        return this;
    }

    public MailerMessage bcc(String email, String person) throws AddressException {
        this.getBcc().add((Address)EmailUtils.parseAddress(email, person));
        return this;
    }

    public MailerMessage subject(String subject) {
        this.subject = subject;
        return this;
    }

    public MailerMessage content(Multipart content) {
        this.content = AssertUtils.assertNotNull(content);
        return this;
    }

    public MailerMessage content(Object content, String type) {
        this.content = AssertUtils.assertNotNull(content);
        this.contentType = AssertUtils.assertNotNull(type);
        return this;
    }

    public MailerMessage htmlContent(String content) {
        return this.content(content, "text/html;charset=utf-8");
    }

    public MailerMessage textContent(String content) {
        return this.content(content, "text/plain;charset=utf-8");
    }

    public MailerMessage sentDate(Date sentDate) {
        this.sentDate = sentDate;
        return this;
    }

    public MailerMessage msgInit(Consumer<MimeMessage> msgInit) {
        this.msgInit = msgInit;
        return this;
    }

    public void send(SmtpMailer mailer) throws MessagingException {
        mailer.send(this);
    }

    public MimeMessage toMimeMessage(SmtpMailer mailer, String debugToEmails) throws MessagingException {
        MimeMessage msg = new MimeMessage(mailer.session);
        if (this.sender != null) {
            msg.setSender(this.sender);
        } else {
            msg.removeHeader("Sender");
        }
        if (this.from != null) {
            msg.addFrom(this.from.toArray(new Address[this.from.size()]));
        }
        if (this.replyTo != null) {
            msg.setReplyTo(this.replyTo.toArray(new Address[this.replyTo.size()]));
        }
        if (debugToEmails != null) {
            msg.addRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)debugToEmails));
        } else {
            if (this.to != null) {
                msg.addRecipients(Message.RecipientType.TO, this.to.toArray(new Address[this.to.size()]));
            }
            if (this.cc != null) {
                msg.addRecipients(Message.RecipientType.CC, this.cc.toArray(new Address[this.cc.size()]));
            }
            if (this.bcc != null) {
                msg.addRecipients(Message.RecipientType.BCC, this.bcc.toArray(new Address[this.bcc.size()]));
            }
        }
        msg.setSubject(this.subject, StandardCharsets.UTF_8.name());
        if (this.content != null) {
            msg.setContent(this.content, this.contentType);
        }
        if (this.sentDate != null) {
            msg.setSentDate(this.sentDate);
        }
        if (this.msgInit != null) {
            this.msgInit.accept(msg);
        }
        return msg;
    }

    protected List<Address> getFrom() {
        if (this.from == null) {
            this.from = new ArrayList<Address>();
        }
        return this.from;
    }

    protected List<Address> getReplyTo() {
        if (this.replyTo == null) {
            this.replyTo = new ArrayList<Address>();
        }
        return this.replyTo;
    }

    protected List<Address> getTo() {
        if (this.to == null) {
            this.to = new ArrayList<Address>();
        }
        return this.to;
    }

    protected List<Address> getCc() {
        if (this.cc == null) {
            this.cc = new ArrayList<Address>();
        }
        return this.cc;
    }

    protected List<Address> getBcc() {
        if (this.bcc == null) {
            this.bcc = new ArrayList<Address>();
        }
        return this.bcc;
    }
}

