/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.logging;

import com.appslandia.common.logging.AppLogger;
import com.appslandia.common.logging.AppLoggerManager;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JulAppLoggerManager
extends AppLoggerManager {
    @Override
    protected AppLogger createAppLogger(String name) {
        return new JulAppLogger(Logger.getLogger(name));
    }

    static class JulAppLogger
    implements AppLogger {
        final Logger logger;

        public JulAppLogger(Logger logger) {
            this.logger = logger;
        }

        @Override
        public boolean isLoggable(AppLogger.Level level) {
            return this.logger.isLoggable(JulAppLogger.toImplLevel(level));
        }

        @Override
        public void log(AppLogger.Level level, String message) {
            Level l = JulAppLogger.toImplLevel(level);
            if (this.logger.isLoggable(l)) {
                this.logger.log(l, message);
            }
        }

        @Override
        public void log(AppLogger.Level level, String message, Throwable exception) {
            Level l = JulAppLogger.toImplLevel(level);
            if (this.logger.isLoggable(l)) {
                this.logger.log(l, message, exception);
            }
        }

        @Override
        public void log(AppLogger.Level level, Supplier<String> msgSupplier) {
            Level l = JulAppLogger.toImplLevel(level);
            if (this.logger.isLoggable(l)) {
                this.logger.log(l, msgSupplier);
            }
        }

        @Override
        public void log(AppLogger.Level level, Supplier<String> msgSupplier, Throwable exception) {
            Level l = JulAppLogger.toImplLevel(level);
            if (this.logger.isLoggable(l)) {
                this.logger.log(l, exception, msgSupplier);
            }
        }

        static Level toImplLevel(AppLogger.Level level) {
            switch (level) {
                case ALL: {
                    return Level.ALL;
                }
                case TRACE: {
                    return Level.FINER;
                }
                case DEBUG: {
                    return Level.FINE;
                }
                case INFO: {
                    return Level.INFO;
                }
                case WARN: {
                    return Level.WARNING;
                }
                case ERROR: {
                    return Level.SEVERE;
                }
            }
            return Level.OFF;
        }
    }
}

