/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.logging;

import com.appslandia.common.base.ExceptionBlock;
import com.appslandia.common.utils.ExceptionUtils;
import com.appslandia.common.utils.StringFormat;
import java.util.function.Supplier;

public interface AppLogger {
    public boolean isLoggable(Level var1);

    public void log(Level var1, String var2);

    public void log(Level var1, String var2, Throwable var3);

    public void log(Level var1, Supplier<String> var2);

    public void log(Level var1, Supplier<String> var2, Throwable var3);

    default public void trace(String message) {
        this.log(Level.TRACE, message);
    }

    default public void debug(String message) {
        this.log(Level.DEBUG, message);
    }

    default public void info(String message) {
        this.log(Level.INFO, message);
    }

    default public void warn(String message) {
        this.log(Level.WARN, message);
    }

    default public void error(String message) {
        this.log(Level.ERROR, message);
    }

    default public void error(String message, Throwable exception) {
        this.log(Level.ERROR, message, exception);
    }

    default public void error(Throwable exception) {
        this.log(Level.ERROR, ExceptionUtils.buildMessage(exception), exception);
    }

    default public void log(Level level, String format, Object ... entries) {
        this.log(level, StringFormat.fmt(format, entries));
    }

    default public void trace(String format, Object ... entries) {
        this.log(Level.TRACE, format, entries);
    }

    default public void debug(String format, Object ... entries) {
        this.log(Level.DEBUG, format, entries);
    }

    default public void info(String format, Object ... entries) {
        this.log(Level.INFO, format, entries);
    }

    default public void warn(String format, Object ... entries) {
        this.log(Level.WARN, format, entries);
    }

    default public void error(String format, Object ... entries) {
        this.log(Level.ERROR, format, entries);
    }

    default public void error(ExceptionBlock block) {
        try {
            block.run();
        }
        catch (Exception ex) {
            this.error(ex);
        }
    }

    public static enum Level {
        ALL(Integer.MIN_VALUE),
        TRACE(400),
        DEBUG(500),
        INFO(800),
        WARN(900),
        ERROR(1000),
        OFF(Integer.MAX_VALUE);

        final int severity;

        private Level(int severity) {
            this.severity = severity;
        }

        public String getName() {
            return this.name();
        }

        public int getSeverity() {
            return this.severity;
        }
    }
}

