/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.utils.AssertUtils;
import java.lang.reflect.Array;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class JwtUtils {
    private static final Pattern JWT_SEP_PATTERN = Pattern.compile("\\.");

    public static String[] parseParts(String token) {
        AssertUtils.assertNotNull(token);
        String[] parts = JWT_SEP_PATTERN.split(token);
        if (parts.length == 2) {
            String[] stringArray;
            if (token.endsWith(".")) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = parts[0];
                stringArray2[1] = parts[1];
                stringArray = stringArray2;
                stringArray2[2] = null;
            } else {
                stringArray = null;
            }
            return stringArray;
        }
        if (parts.length != 3) {
            return null;
        }
        return parts;
    }

    public static Long toNumericDate(Date value) {
        if (value == null) {
            return null;
        }
        return value.getTime() / 1000L;
    }

    public static Long toNumericDate(Long timeInMs) {
        if (timeInMs == null) {
            return null;
        }
        return timeInMs / 1000L;
    }

    public static boolean isFutureTime(long numericDate, int leewaySec) {
        return System.currentTimeMillis() / 1000L - (long)leewaySec < numericDate;
    }

    public static boolean isPastTime(long numericDate, int leewaySec) {
        return System.currentTimeMillis() / 1000L + (long)leewaySec >= numericDate;
    }

    public static Date toDate(Long numericDate) {
        if (numericDate == null) {
            return null;
        }
        return new Date(numericDate * 1000L);
    }

    public static boolean isSupportedValue(Object value) {
        AssertUtils.assertNotNull(value);
        if (value instanceof List) {
            return JwtUtils.validateList((List)value);
        }
        if (value instanceof Map) {
            return JwtUtils.validateMap((Map)value);
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            return JwtUtils.validateArray(value);
        }
        return JwtUtils.isBasicType(type);
    }

    private static boolean validateMap(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getKey() == null || entry.getKey().getClass() != String.class) {
                return false;
            }
            if (entry.getValue() == null || JwtUtils.isSupportedValue(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    private static boolean validateList(List<?> list) {
        for (Object value : list) {
            if (value == null || JwtUtils.isSupportedValue(value)) continue;
            return false;
        }
        return true;
    }

    private static boolean validateArray(Object array) {
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(array, i);
            if (value == null || JwtUtils.isSupportedValue(value)) continue;
            return false;
        }
        return true;
    }

    private static boolean isBasicType(Class<?> c) {
        return c == String.class || c == Integer.class || c == Long.class || c == Double.class || c == Boolean.class || Date.class.isAssignableFrom(c);
    }
}

