/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.crypto.Digester;
import com.appslandia.common.crypto.DsaDigester;
import com.appslandia.common.crypto.MacDigester;
import com.appslandia.common.utils.AssertUtils;
import java.util.Arrays;

public class JwtSigner
extends InitializeObject {
    private static final byte[] EMPTY_SIG = new byte[0];
    public static final JwtSigner NONE = new JwtSigner().setAlg("none");
    private String alg;
    private Digester signer;
    private String kid;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.alg, "alg is required.");
        if (this != NONE) {
            AssertUtils.assertNotNull(this.signer, "signer is required.");
        }
    }

    public byte[] sign(byte[] message) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        if (this == NONE) {
            return EMPTY_SIG;
        }
        return this.signer.digest(message);
    }

    public boolean verify(byte[] message, byte[] signature) throws CryptoException {
        this.initialize();
        AssertUtils.assertNotNull(message, "message is required.");
        AssertUtils.assertNotNull(signature, "signature is required.");
        if (this == NONE) {
            return Arrays.equals(signature, EMPTY_SIG);
        }
        return this.signer.verify(message, signature);
    }

    public String getAlg() {
        this.initialize();
        return this.alg;
    }

    public JwtSigner setAlg(String alg) {
        this.assertNotInitialized();
        this.alg = alg;
        return this;
    }

    public Digester getSigner() {
        this.initialize();
        return this.signer;
    }

    public JwtSigner setSigner(MacDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    public JwtSigner setSigner(DsaDigester signer) {
        this.assertNotInitialized();
        this.signer = signer;
        return this;
    }

    public String getKid() {
        this.initialize();
        return this.kid;
    }

    public JwtSigner setKid(String kid) {
        this.assertNotInitialized();
        this.kid = kid;
        return this;
    }

    public JwtSigner copy() {
        if (this == NONE) {
            return NONE;
        }
        JwtSigner impl = new JwtSigner();
        impl.alg = this.alg;
        if (this.signer != null) {
            impl.signer = this.signer.copy();
        }
        impl.kid = this.kid;
        return impl;
    }
}

