/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.base.BaseEncoder;
import com.appslandia.common.base.DestroyException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.crypto.CryptoException;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.json.JsonProcessor;
import com.appslandia.common.jwt.JwtException;
import com.appslandia.common.jwt.JwtHeader;
import com.appslandia.common.jwt.JwtPayload;
import com.appslandia.common.jwt.JwtSigner;
import com.appslandia.common.jwt.JwtToken;
import com.appslandia.common.jwt.JwtUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.ValueUtils;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;

public class JwtProcessor
extends InitializeObject {
    protected JsonProcessor jsonProcessor;
    protected JwtSigner jwtSigner;
    protected String issuer;

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.jsonProcessor, "jsonProcessor is required.");
        this.jwtSigner = ValueUtils.valueOrAlt(this.jwtSigner, JwtSigner.NONE);
    }

    @Override
    public void destroy() throws DestroyException {
        if (this.jsonProcessor != null) {
            this.jsonProcessor.destroy();
        }
        if (this.jwtSigner != null) {
            this.jwtSigner.destroy();
        }
    }

    public JwtHeader newHeader() {
        this.initialize();
        return new JwtHeader().setType("JWT").setAlgorithm(this.jwtSigner.getAlg());
    }

    public JwtPayload newPayload() {
        this.initialize();
        return new JwtPayload().setIssuer(this.issuer);
    }

    public String toJwt(JwtToken jwt) throws CryptoException, JsonException, JwtException {
        this.initialize();
        AssertUtils.assertNotNull(jwt);
        AssertUtils.assertNotNull(jwt.getHeader());
        AssertUtils.assertNotNull(jwt.getPayload());
        String base64Header = BaseEncoder.BASE64_URL.encode(this.jsonProcessor.toByteArray(jwt.getHeader()));
        String base64Payload = BaseEncoder.BASE64_URL.encode(this.jsonProcessor.toByteArray(jwt.getPayload()));
        if (this.jwtSigner == JwtSigner.NONE) {
            return JwtProcessor.newBuilder(base64Header, base64Payload, 1).append(".").toString();
        }
        String dataToSign = JwtProcessor.newBuilder(base64Header, base64Payload, 0).toString();
        String base64Sig = BaseEncoder.BASE64_URL.encode(this.jwtSigner.sign(dataToSign.getBytes(StandardCharsets.UTF_8)));
        return JwtProcessor.newBuilder(base64Header, base64Payload, 1 + base64Sig.length()).append(".").append(base64Sig).toString();
    }

    public JwtToken parseJwt(String jwt) throws IllegalArgumentException, CryptoException, JsonException, JwtException {
        this.initialize();
        AssertUtils.assertNotNull(jwt);
        String[] parts = JwtUtils.parseParts(jwt);
        if (parts == null) {
            throw new JwtException("JWT token is invalid format.");
        }
        if (parts[2] == null) {
            if (this.jwtSigner != JwtSigner.NONE) {
                throw new JwtException("JWT signature is required.");
            }
        } else {
            if (this.jwtSigner == JwtSigner.NONE) {
                throw new JwtException("jwtSigner is required.");
            }
            String dataToSign = JwtProcessor.newBuilder(parts[0], parts[1], 0).toString();
            if (!this.jwtSigner.verify(dataToSign.getBytes(StandardCharsets.UTF_8), BaseEncoder.BASE64_URL.decode(parts[2]))) {
                throw new JwtException("JWT signature is invalid.");
            }
        }
        String headerJson = new String(BaseEncoder.BASE64_URL.decode(parts[0]), StandardCharsets.UTF_8);
        JwtHeader header = this.jsonProcessor.read((Reader)new StringReader(headerJson), JwtHeader.class);
        String payloadJson = new String(BaseEncoder.BASE64_URL.decode(parts[1]), StandardCharsets.UTF_8);
        JwtPayload payload = this.jsonProcessor.read((Reader)new StringReader(payloadJson), JwtPayload.class);
        return new JwtToken(header, payload);
    }

    public JsonProcessor getJsonProcessor() {
        this.initialize();
        return this.jsonProcessor;
    }

    public JwtProcessor setJsonProcessor(JsonProcessor jsonProcessor) {
        this.assertNotInitialized();
        this.jsonProcessor = jsonProcessor;
        return this;
    }

    public JwtSigner getJwtSigner() {
        this.initialize();
        return this.jwtSigner;
    }

    public JwtProcessor setJwtSigner(JwtSigner jwtSigner) {
        this.assertNotInitialized();
        this.jwtSigner = jwtSigner;
        return this;
    }

    public JwtProcessor setIssuer(String issuer) {
        this.assertNotInitialized();
        this.issuer = issuer;
        return this;
    }

    static StringBuilder newBuilder(String base64Header, String base64Payload, int signtureLen) {
        return new StringBuilder(base64Header.length() + 1 + base64Payload.length() + signtureLen).append(base64Header).append(".").append(base64Payload);
    }
}

