/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.jwt.JwtClaims;
import com.appslandia.common.utils.CollectionUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class JwtPayload
extends JwtClaims {
    private static final long serialVersionUID = 1L;
    public static final String ISS = "iss";
    public static final String SUB = "sub";
    public static final String AUD = "aud";
    public static final String EXP = "exp";
    public static final String NBF = "nbf";
    public static final String IAT = "iat";
    public static final String JTI = "jti";

    public JwtPayload() {
    }

    public JwtPayload(Map<String, Object> map) {
        super(map);
    }

    @Override
    public JwtPayload set(String key, Object value) {
        super.set(key, value);
        return this;
    }

    @Override
    public JwtPayload setArray(String key, Object ... values) {
        super.setArray(key, values);
        return this;
    }

    @Override
    public JwtPayload setNumericDate(String key, Date value) {
        super.setNumericDate(key, value);
        return this;
    }

    @Override
    public JwtPayload setNumericDate(String key, long timeInMs) {
        super.setNumericDate(key, timeInMs);
        return this;
    }

    public String getIssuer() {
        return (String)this.get(ISS);
    }

    public JwtPayload setIssuer(String value) {
        this.put(ISS, (Object)value);
        return this;
    }

    public String getSubject() {
        return (String)this.get(SUB);
    }

    public JwtPayload setSubject(String value) {
        this.put(SUB, (Object)value);
        return this;
    }

    public List<String> getAudiences() {
        Object value = this.get(AUD);
        if (value == null) {
            return null;
        }
        if (value.getClass() == String.class) {
            return CollectionUtils.toList(new ArrayList(1), new String[]{(String)value});
        }
        return (List)ObjectUtils.cast(value);
    }

    public JwtPayload setAudiences(String ... values) {
        if (values.length == 0) {
            return this;
        }
        this.put(AUD, values.length == 1 ? values[0] : CollectionUtils.toList(values));
        return this;
    }

    public Date getExpiresAt() {
        return this.getNumericDate(EXP);
    }

    public JwtPayload setExpiresAt(Date value) {
        this.setNumericDate(EXP, value);
        return this;
    }

    public JwtPayload setExpiresIn(long expiresIn, TimeUnit unit) {
        this.setNumericDate(EXP, System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(expiresIn, unit));
        return this;
    }

    public Date getNotBefore() {
        return this.getNumericDate(NBF);
    }

    public JwtPayload setNotBefore(Date value) {
        this.setNumericDate(NBF, value);
        return this;
    }

    public Date getIssuedAt() {
        return this.getNumericDate(IAT);
    }

    public JwtPayload setIssuedAt(Date value) {
        this.setNumericDate(IAT, value);
        return this;
    }

    public JwtPayload setIssuedAtNow() {
        return this.setIssuedAt(new Date());
    }

    public String getJwtId() {
        return (String)this.get(JTI);
    }

    public JwtPayload setJwtId(String value) {
        this.put(JTI, (Object)value);
        return this;
    }
}

