/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jwt;

import com.appslandia.common.base.MapWrapper;
import com.appslandia.common.jwt.JwtUtils;
import com.appslandia.common.utils.AssertUtils;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class JwtClaims
extends MapWrapper<String, Object> {
    private static final long serialVersionUID = 1L;

    public JwtClaims() {
        super(new LinkedHashMap());
    }

    public JwtClaims(Map<String, Object> map) {
        super(map);
    }

    @Override
    public Object put(String key, Object value) {
        AssertUtils.assertNotNull(key);
        if (value == null) {
            return this.remove(key);
        }
        AssertUtils.assertTrue(JwtUtils.isSupportedValue(value), "value is unsupported.");
        return super.put(key, value);
    }

    public JwtClaims set(String key, Object value) {
        this.put(key, value);
        return this;
    }

    public JwtClaims setArray(String key, Object ... values) {
        this.put(key, (Object)values);
        return this;
    }

    public Date getNumericDate(String key) {
        Number nd = (Number)this.get(key);
        return nd != null ? JwtUtils.toDate(nd.longValue()) : null;
    }

    public JwtClaims setNumericDate(String key, Date value) {
        return this.set(key, JwtUtils.toNumericDate(value));
    }

    public JwtClaims setNumericDate(String key, long timeInMs) {
        return this.set(key, JwtUtils.toNumericDate(timeInMs));
    }

    public Date getDate(String key) {
        Object d = this.get(key);
        if (d == null) {
            return null;
        }
        if (d instanceof Date) {
            return (Date)d;
        }
        if (d.getClass() == Long.class) {
            return new Date((Long)d);
        }
        throw new IllegalStateException("Date conversion failed.");
    }
}

