/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.junit.jpa;

import com.appslandia.common.junit.jpa.SharedEmfTestEntityManagerExtension;
import com.appslandia.common.junit.jpa.TestEmfControl;
import com.appslandia.common.junit.jpa.TestEntityManagerExtension;
import jakarta.inject.Inject;
import jakarta.interceptor.InvocationContext;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.transaction.InvalidTransactionException;
import jakarta.transaction.Transactional;
import java.io.Serializable;

public abstract class TestTxInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    protected TestEmfControl testEmfControl;

    public Object doTran(InvocationContext context) throws Exception {
        EntityTransaction et;
        boolean inTrans;
        boolean startNew;
        Transactional.TxType type;
        Transactional tx = context.getMethod().getAnnotation(Transactional.class);
        if (tx == null) {
            tx = context.getTarget().getClass().getAnnotation(Transactional.class);
        }
        if ((type = tx.value()) == Transactional.TxType.NEVER) {
            EntityManager curEm = this.getEm();
            if (curEm != null && curEm.getTransaction().isActive()) {
                throw new InvalidTransactionException("TxType.NEVER - Transaction active found.");
            }
            this.setEm(null);
            try {
                Object object = context.proceed();
                return object;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.setEm(curEm);
            }
        }
        if (type == Transactional.TxType.MANDATORY) {
            EntityManager curEm = this.getEm();
            if (curEm == null || !curEm.getTransaction().isActive()) {
                throw new InvalidTransactionException("TxType.MANDATORY - No transaction active found.");
            }
            return context.proceed();
        }
        if (type == Transactional.TxType.SUPPORTS) {
            EntityManager curEm = this.getEm();
            if (curEm != null && curEm.getTransaction().isActive()) {
                return context.proceed();
            }
            this.setEm(null);
            try {
                Object ex = context.proceed();
                return ex;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.setEm(curEm);
            }
        }
        if (type == Transactional.TxType.NOT_SUPPORTED) {
            EntityManager curEm = this.getEm();
            this.setEm(null);
            try {
                Object ex = context.proceed();
                return ex;
            }
            catch (Exception ex) {
                throw ex;
            }
            finally {
                this.setEm(curEm);
            }
        }
        if (type == Transactional.TxType.REQUIRES_NEW) {
            EntityManager curEm = this.getEm();
            EntityManager newEm = this.storeNewEm();
            EntityTransaction et2 = newEm.getTransaction();
            et2.begin();
            try {
                Object obj = context.proceed();
                et2.commit();
                Object object = obj;
                return object;
            }
            catch (Exception ex) {
                if (this.willRollbackOn(ex, tx.rollbackOn(), tx.dontRollbackOn())) {
                    et2.rollback();
                }
                throw ex;
            }
            finally {
                newEm.close();
                this.setEm(curEm);
            }
        }
        EntityManager curEm = this.getEm();
        boolean bl = startNew = curEm == null;
        if (startNew) {
            curEm = this.storeNewEm();
        }
        if (!(inTrans = (et = curEm.getTransaction()).isActive())) {
            et.begin();
        }
        try {
            Object obj = context.proceed();
            if (!inTrans) {
                et.commit();
            }
            Object object = obj;
            return object;
        }
        catch (Exception ex) {
            if (!inTrans && this.willRollbackOn(ex, tx.rollbackOn(), tx.dontRollbackOn())) {
                et.rollback();
            }
            throw ex;
        }
        finally {
            if (startNew) {
                this.setEm(null);
            }
        }
    }

    protected EntityManager getEm() {
        if (this.testEmfControl.isSharedEmf()) {
            return SharedEmfTestEntityManagerExtension.emHolder.get();
        }
        return TestEntityManagerExtension.emHolder.get();
    }

    protected EntityManager storeNewEm() {
        if (this.testEmfControl.isSharedEmf()) {
            return SharedEmfTestEntityManagerExtension.newEntityManager();
        }
        return TestEntityManagerExtension.newEntityManager();
    }

    protected void setEm(EntityManager em) {
        if (this.testEmfControl.isSharedEmf()) {
            SharedEmfTestEntityManagerExtension.emHolder.set(em);
        } else {
            TestEntityManagerExtension.emHolder.set(em);
        }
    }

    protected boolean willRollbackOn(Exception ex, Class<?>[] rollbackOn, Class<?>[] dontRollbackOn) {
        if (ex instanceof RuntimeException) {
            Class<?> dontRollbackOnClass = this.getClosestMatchOrNull(dontRollbackOn, ex.getClass());
            if (dontRollbackOnClass == null) {
                return true;
            }
            if (dontRollbackOnClass.equals(ex.getClass()) || dontRollbackOnClass.isAssignableFrom(ex.getClass())) {
                return false;
            }
            Class<?> rollbackOnClass = this.getClosestMatchOrNull(rollbackOn, ex.getClass());
            if (rollbackOnClass != null) {
                if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                    return false;
                }
                if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                    return true;
                }
            }
            return true;
        }
        Class<?> rollbackOnClass = this.getClosestMatchOrNull(rollbackOn, ex.getClass());
        if (rollbackOnClass == null) {
            return false;
        }
        Class<?> dontRollbackOnClass = this.getClosestMatchOrNull(dontRollbackOn, ex.getClass());
        if (dontRollbackOnClass != null) {
            if (rollbackOnClass.isAssignableFrom(dontRollbackOnClass)) {
                return false;
            }
            if (dontRollbackOnClass.isAssignableFrom(rollbackOnClass)) {
                return true;
            }
        }
        return rollbackOnClass.equals(ex.getClass()) || rollbackOnClass.isAssignableFrom(ex.getClass());
    }

    private Class<?> getClosestMatchOrNull(Class<?>[] exClasses, Class<?> exceptionClass) {
        Class<?> closestMatch = null;
        for (Class<?> exClass : exClasses) {
            if (exClass.equals(exceptionClass)) {
                return exClass;
            }
            if (!exClass.isAssignableFrom(exceptionClass) || closestMatch != null && !closestMatch.isAssignableFrom(exClass)) continue;
            closestMatch = exClass;
        }
        return closestMatch;
    }
}

