/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.junit.jpa;

import com.appslandia.common.threading.ThreadLocalStorage;
import com.appslandia.common.utils.AssertUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.Persistence;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class TestEntityManagerExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    static final ThreadLocalStorage<EntityManagerFactory> emfHolder = new ThreadLocalStorage();
    static final ThreadLocalStorage<EntityManager> emHolder = new ThreadLocalStorage();

    protected abstract String getPUName();

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.getPUName());
    }

    public void beforeEach(ExtensionContext context) throws Exception {
        EntityManager em;
        EntityManagerFactory emf = emfHolder.get();
        if (emf == null) {
            emf = this.createEntityManagerFactory();
            emfHolder.set(emf);
        }
        if ((em = emHolder.get()) != null) {
            return;
        }
        emHolder.set(emf.createEntityManager());
    }

    public void afterEach(ExtensionContext context) throws Exception {
        EntityManager em = emHolder.remove();
        AssertUtils.assertStateNotNull(em);
        em.close();
        EntityManagerFactory emf = emfHolder.remove();
        AssertUtils.assertStateNotNull(emf);
        emf.close();
    }

    public void beforeAll(ExtensionContext context) throws Exception {
    }

    public void afterAll(ExtensionContext context) throws Exception {
    }

    public static EntityManager newEntityManager() {
        EntityManager em = emfHolder.val().createEntityManager();
        emHolder.set(em);
        return em;
    }
}

