/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.junit.jpa;

import com.appslandia.common.threading.ThreadLocalStorage;
import com.appslandia.common.utils.AssertUtils;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Persistence;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class SharedEmfTestEntityManagerExtension
implements BeforeEachCallback,
AfterEachCallback,
BeforeAllCallback,
AfterAllCallback {
    static final ThreadLocalStorage<EntityManager> emHolder = new ThreadLocalStorage();
    private static volatile EntityManagerFactory emf;
    static final Object MUTEX;

    protected abstract String getPUName();

    protected EntityManagerFactory createEntityManagerFactory() {
        return Persistence.createEntityManagerFactory((String)this.getPUName());
    }

    protected abstract void initEach(ExtensionContext var1, EntityManager var2);

    public void beforeEach(ExtensionContext context) throws Exception {
        EntityManager em = emHolder.get();
        if (em != null) {
            return;
        }
        em = emf.createEntityManager();
        emHolder.set(em);
        EntityTransaction et = em.getTransaction();
        et.begin();
        try {
            this.initEach(context, em);
            et.commit();
        }
        catch (Exception ex) {
            et.rollback();
            throw ex;
        }
    }

    public void afterEach(ExtensionContext context) throws Exception {
        EntityManager em = emHolder.remove();
        AssertUtils.assertStateNotNull(em);
        em.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeAll(ExtensionContext context) throws Exception {
        if (emf == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (emf == null) {
                    emf = this.createEntityManagerFactory();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterAll(ExtensionContext context) throws Exception {
        if (emf != null) {
            Object object = MUTEX;
            synchronized (object) {
                if (emf != null) {
                    emf.close();
                    emf = null;
                }
            }
        }
    }

    public static EntityManager newEntityManager() {
        AssertUtils.assertStateNotNull(emf);
        EntityManager em = emf.createEntityManager();
        emHolder.set(em);
        return em;
    }

    static {
        MUTEX = new Object();
    }
}

