/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.utils.DateUtils;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Date;
import java.text.ParseException;

public class SqlDateAdapter
implements JsonSerializer<Date>,
JsonDeserializer<Date> {
    public JsonElement serialize(Date src, Type typeOfSrc, JsonSerializationContext context) {
        return new JsonPrimitive(DateUtils.newDateFormat("yyyy-MM-dd").format(src));
    }

    public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        try {
            return new Date(DateUtils.newDateFormat("yyyy-MM-dd").parse(json.getAsString()).getTime());
        }
        catch (ParseException ex) {
            throw new JsonParseException((Throwable)ex);
        }
    }
}

