/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.MemoryStream;
import com.appslandia.common.base.StringWriter;
import com.appslandia.common.json.JsonException;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.ReflectionUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public abstract class JsonProcessor
extends InitializeObject {
    private static JsonProcessor __default;
    private static final Object MUTEX;
    private static Supplier<JsonProcessor> __provider;

    public abstract void write(Writer var1, Object var2) throws JsonException;

    public abstract <T> T read(Reader var1, Class<T> var2) throws JsonException;

    public abstract <T> T read(Reader var1, Type var2) throws JsonException;

    public <V> Map<String, V> readAsMap(Reader reader) throws JsonException {
        return (Map)ObjectUtils.cast(this.read(reader, HashMap.class));
    }

    public <V> Map<String, V> readAsLinkedMap(Reader reader) throws JsonException {
        return (Map)ObjectUtils.cast(this.read(reader, LinkedHashMap.class));
    }

    public String toString(Object obj) throws JsonException {
        StringWriter out = new StringWriter(128);
        this.write(out, obj);
        return out.toString();
    }

    public byte[] toByteArray(Object obj) throws JsonException {
        MemoryStream content = new MemoryStream(512);
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)content, StandardCharsets.UTF_8);){
            this.write(out, obj);
        }
        catch (IOException ex) {
            throw new JsonException(ex);
        }
        return content.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonProcessor getDefault() {
        JsonProcessor obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = JsonProcessor.initJsonProcessor();
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(JsonProcessor impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __default = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("JsonProcessor.__default must be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProvider(Supplier<JsonProcessor> impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __provider = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("JsonProcessor.__default must be null.");
    }

    private static JsonProcessor initJsonProcessor() {
        if (__provider != null) {
            return __provider.get();
        }
        try {
            Class implClass = ReflectionUtils.loadClass("com.appslandia.common.json.GsonProcessor", null);
            return (JsonProcessor)ReflectionUtils.newInstance(implClass);
        }
        catch (Exception ex) {
            throw new InitializeException(ex);
        }
    }

    static {
        MUTEX = new Object();
    }
}

