/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.utils.AssertUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;

public class GsonMapParser {
    public Map<String, Object> parseMap(JsonObject jsonObject, Supplier<Map<String, Object>> newMap, boolean makeReadonly) {
        AssertUtils.assertTrue(jsonObject.isJsonObject());
        Map<String, Object> map = newMap.get();
        for (String key : jsonObject.keySet()) {
            map.put(key, this.parseValue(jsonObject.get(key), makeReadonly));
        }
        return makeReadonly ? Collections.unmodifiableMap(map) : map;
    }

    public Object parseValue(JsonElement element, boolean makeReadonly) {
        if (element.isJsonNull()) {
            return null;
        }
        if (element.isJsonPrimitive()) {
            JsonPrimitive jsonPrim = element.getAsJsonPrimitive();
            if (jsonPrim.isString()) {
                return element.getAsString();
            }
            if (jsonPrim.isBoolean()) {
                return element.getAsBoolean();
            }
            if (jsonPrim.isNumber()) {
                String str = element.getAsString();
                if (str.contains(".")) {
                    return element.getAsDouble();
                }
                return element.getAsLong();
            }
            throw new AssertionError();
        }
        if (element.isJsonArray()) {
            JsonArray jsonArray = element.getAsJsonArray();
            ArrayList<Object> list = new ArrayList<Object>(jsonArray.size());
            for (JsonElement jsonElement : jsonArray) {
                list.add(this.parseValue(jsonElement, makeReadonly));
            }
            return makeReadonly ? Collections.unmodifiableList(list) : list;
        }
        if (element.isJsonObject()) {
            JsonObject jsonObject = element.getAsJsonObject();
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(jsonObject.keySet().size());
            for (String key : jsonObject.keySet()) {
                map.put(key, this.parseValue(jsonObject.get(key), makeReadonly));
            }
            return makeReadonly ? Collections.unmodifiableMap(map) : map;
        }
        throw new IllegalStateException();
    }
}

