/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.json;

import com.appslandia.common.json.GsonMapParser;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public class GsonMapDeserializer<T extends Map<String, Object>>
implements JsonDeserializer<T> {
    final Function<Map<String, Object>, T> converter;
    final boolean makeReadonly;

    public GsonMapDeserializer(Function<Map<String, Object>, T> converter) {
        this(converter, false);
    }

    public GsonMapDeserializer(Function<Map<String, Object>, T> converter, boolean makeReadonly) {
        this.converter = converter;
        this.makeReadonly = makeReadonly;
    }

    public T deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Map<String, Object> map = new GsonMapParser().parseMap(json.getAsJsonObject(), () -> new LinkedHashMap(), this.makeReadonly);
        return (T)((Map)this.converter.apply(map));
    }
}

