/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.jdbc.LikeType;
import com.appslandia.common.jdbc.SqlLikeEscaper;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.TagUtils;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.Query;
import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class QueryAccessor
implements Query {
    final Query q;

    public QueryAccessor(Query q) {
        this.q = q;
    }

    public <T> T getFirstOrNull() {
        List<T> results = this.setMaxResults(1).getTypedList();
        return !results.isEmpty() ? (T)results.get(0) : null;
    }

    public <T> T getSingleOrNull() {
        try {
            return ObjectUtils.cast(this.q.getSingleResult());
        }
        catch (NoResultException ex) {
            return null;
        }
    }

    public <T> List<T> getTypedList() {
        return (List)ObjectUtils.cast(this.getResultList());
    }

    public QueryAccessor setStartPos(int pos) {
        this.q.setFirstResult(pos);
        return this;
    }

    public QueryAccessor setLikeTag(String parameterName, String tag) {
        return this.setLikePattern(parameterName, TagUtils.wrapTag(tag));
    }

    public QueryAccessor setLikePattern(String parameterName, String value) {
        this.q.setParameter(parameterName, (Object)SqlLikeEscaper.toLikePattern(value, LikeType.CONTAINS));
        return this;
    }

    public QueryAccessor setLikeStart(String parameterName, String value) {
        this.q.setParameter(parameterName, (Object)SqlLikeEscaper.toLikePattern(value, LikeType.STARTS_WITH));
        return this;
    }

    public QueryAccessor setLikeEnd(String parameterName, String value) {
        this.q.setParameter(parameterName, (Object)SqlLikeEscaper.toLikePattern(value, LikeType.ENDS_WITH));
        return this;
    }

    public Map<String, Object> getHints() {
        return this.q.getHints();
    }

    public int getFirstResult() {
        return this.q.getFirstResult();
    }

    public FlushModeType getFlushMode() {
        return this.q.getFlushMode();
    }

    public LockModeType getLockMode() {
        return this.q.getLockMode();
    }

    public int getMaxResults() {
        return this.q.getMaxResults();
    }

    public Parameter<?> getParameter(int position) {
        return this.q.getParameter(position);
    }

    public Parameter<?> getParameter(String name) {
        return this.q.getParameter(name);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this.q.getParameter(position, type);
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this.q.getParameter(name, type);
    }

    public Object getParameterValue(int position) {
        return this.q.getParameterValue(position);
    }

    public Object getParameterValue(String name) {
        return this.q.getParameterValue(name);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return (T)this.q.getParameterValue(param);
    }

    public Set<Parameter<?>> getParameters() {
        return this.q.getParameters();
    }

    public List getResultList() {
        return this.q.getResultList();
    }

    public Stream getResultStream() {
        return this.q.getResultStream();
    }

    public Object getSingleResult() {
        return this.q.getSingleResult();
    }

    public QueryAccessor setHint(String hintName, Object value) {
        this.q.setHint(hintName, value);
        return this;
    }

    public QueryAccessor setFirstResult(int startPosition) {
        this.q.setFirstResult(startPosition);
        return this;
    }

    public QueryAccessor setFlushMode(FlushModeType flushMode) {
        this.q.setFlushMode(flushMode);
        return this;
    }

    public QueryAccessor setLockMode(LockModeType lockMode) {
        this.q.setLockMode(lockMode);
        return this;
    }

    public QueryAccessor setMaxResults(int maxResult) {
        this.q.setMaxResults(maxResult);
        return this;
    }

    public QueryAccessor setParameter(int position, Object value) {
        this.q.setParameter(position, value);
        return this;
    }

    public QueryAccessor setParameter(String name, Object value) {
        this.q.setParameter(name, value);
        return this;
    }

    public <T> QueryAccessor setParameter(Parameter<T> param, T value) {
        this.q.setParameter(param, value);
        return this;
    }

    public QueryAccessor setParameter(int position, Calendar value, TemporalType temporalType) {
        this.q.setParameter(position, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(int position, Date value, TemporalType temporalType) {
        this.q.setParameter(position, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(String name, Calendar value, TemporalType temporalType) {
        this.q.setParameter(name, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(String name, Date value, TemporalType temporalType) {
        this.q.setParameter(name, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(Parameter<Calendar> param, Calendar value, TemporalType temporalType) {
        this.q.setParameter(param, value, temporalType);
        return this;
    }

    public QueryAccessor setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.q.setParameter(param, value, temporalType);
        return this;
    }

    public int executeUpdate() {
        return this.q.executeUpdate();
    }

    public boolean isBound(Parameter<?> param) {
        return this.q.isBound(param);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.q.unwrap(cls);
    }
}

