/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jpa;

import com.appslandia.common.base.Params;
import com.appslandia.common.jpa.QueryAccessor;
import com.appslandia.common.jpa.TypedQueryAccessor;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityNotFoundException;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import java.util.List;
import java.util.Map;

public class EntityManagerAccessor
implements EntityManager {
    private EntityManager em;

    public EntityManagerAccessor() {
    }

    public EntityManagerAccessor(EntityManager em) {
        this.em = em;
    }

    protected EntityManager getEm() {
        return this.em;
    }

    public void insert(Object entity) {
        this.getEm().persist(entity);
        this.getEm().flush();
    }

    public void insertRefresh(Object entity) {
        this.getEm().persist(entity);
        this.getEm().flush();
        this.getEm().refresh(entity);
    }

    public void removeByPk(Class<?> type, Object primaryKey) throws EntityNotFoundException {
        Object ref = this.getEm().getReference(type, primaryKey);
        this.getEm().remove(ref);
    }

    public boolean isInCache(Class<?> type, Object primaryKey) {
        Cache cache = this.getEm().getEntityManagerFactory().getCache();
        return cache != null && cache.contains(type, primaryKey);
    }

    public void evictCache() {
        Cache cache = this.getEm().getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evictAll();
        }
    }

    public void evictCache(Class<?> type) {
        Cache cache = this.getEm().getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evict(type);
        }
    }

    public void evictCache(Class<?> type, Object primaryKey) {
        Cache cache = this.getEm().getEntityManagerFactory().getCache();
        if (cache != null) {
            cache.evict(type, primaryKey);
        }
    }

    public <T> T findFetch(Class<T> entityClass, Object primaryKey, String graphName) {
        return (T)this.getEm().find(entityClass, primaryKey, (Map)Params.of("jakarta.persistence.fetchgraph", this.getEm().createEntityGraph(graphName)));
    }

    public <T> T findLoad(Class<T> entityClass, Object primaryKey, String graphName) {
        return (T)this.getEm().find(entityClass, primaryKey, (Map)Params.of("jakarta.persistence.loadgraph", this.getEm().createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createQueryFetch(String qlString, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.getEm().createQuery(qlString, resultClass).setHint("jakarta.persistence.fetchgraph", (Object)this.getEm().createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createQueryLoad(String qlString, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.getEm().createQuery(qlString, resultClass).setHint("jakarta.persistence.loadgraph", (Object)this.getEm().createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createNamedQueryFetch(String name, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.getEm().createNamedQuery(name, resultClass).setHint("jakarta.persistence.fetchgraph", (Object)this.getEm().createEntityGraph(graphName)));
    }

    public <T> TypedQueryAccessor<T> createNamedQueryLoad(String name, Class<T> resultClass, String graphName) {
        return new TypedQueryAccessor(this.getEm().createNamedQuery(name, resultClass).setHint("jakarta.persistence.loadgraph", (Object)this.getEm().createEntityGraph(graphName)));
    }

    public void remove(Object entity) {
        this.getEm().remove(entity);
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.getEm().lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEm().lock(entity, lockMode, properties);
    }

    public void setProperty(String propertyName, Object value) {
        this.getEm().setProperty(propertyName, value);
    }

    public void clear() {
        this.getEm().clear();
    }

    public boolean contains(Object entity) {
        return this.getEm().contains(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEm().find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        return (T)this.getEm().find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        return (T)this.getEm().find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        return (T)this.getEm().find(entityClass, primaryKey, lockMode, properties);
    }

    public Map<String, Object> getProperties() {
        return this.getEm().getProperties();
    }

    public void close() {
        this.getEm().close();
    }

    public void flush() {
        this.getEm().flush();
    }

    public <T> T merge(T entity) {
        return (T)this.getEm().merge(entity);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEm().unwrap(cls);
    }

    public boolean isOpen() {
        return this.getEm().isOpen();
    }

    public void detach(Object entity) {
        this.getEm().detach(entity);
    }

    public QueryAccessor createNativeQuery(String sqlString, Class resultClass) {
        return new QueryAccessor(this.getEm().createNativeQuery(sqlString, resultClass));
    }

    public QueryAccessor createNativeQuery(String sqlString) {
        return new QueryAccessor(this.getEm().createNativeQuery(sqlString));
    }

    public QueryAccessor createNativeQuery(String sqlString, String resultSetMapping) {
        return new QueryAccessor(this.getEm().createNativeQuery(sqlString, resultSetMapping));
    }

    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        return this.getEm().createNamedStoredProcedureQuery(name);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        return this.getEm().createStoredProcedureQuery(procedureName, resultSetMappings);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        return this.getEm().createStoredProcedureQuery(procedureName);
    }

    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        return this.getEm().createStoredProcedureQuery(procedureName, resultClasses);
    }

    public boolean isJoinedToTransaction() {
        return this.getEm().isJoinedToTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEm().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEm().getCriteriaBuilder();
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        return this.getEm().createEntityGraph(rootType);
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        return this.getEm().createEntityGraph(graphName);
    }

    public void persist(Object entity) {
        this.getEm().persist(entity);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        return (T)this.getEm().getReference(entityClass, primaryKey);
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEm().setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.getEm().getFlushMode();
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.getEm().refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.getEm().refresh(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.getEm().refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.getEm().refresh(entity, properties);
    }

    public LockModeType getLockMode(Object entity) {
        return this.getEm().getLockMode(entity);
    }

    public <T> TypedQueryAccessor<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new TypedQueryAccessor(this.getEm().createQuery(criteriaQuery));
    }

    public <T> TypedQueryAccessor<T> createQuery(String qlString, Class<T> resultClass) {
        return new TypedQueryAccessor(this.getEm().createQuery(qlString, resultClass));
    }

    public QueryAccessor createQuery(CriteriaUpdate updateQuery) {
        return new QueryAccessor(this.getEm().createQuery(updateQuery));
    }

    public QueryAccessor createQuery(CriteriaDelete deleteQuery) {
        return new QueryAccessor(this.getEm().createQuery(deleteQuery));
    }

    public QueryAccessor createQuery(String qlString) {
        return new QueryAccessor(this.getEm().createQuery(qlString));
    }

    public <T> TypedQueryAccessor<T> createNamedQuery(String name, Class<T> resultClass) {
        return new TypedQueryAccessor(this.getEm().createNamedQuery(name, resultClass));
    }

    public QueryAccessor createNamedQuery(String name) {
        return new QueryAccessor(this.getEm().createNamedQuery(name));
    }

    public void joinTransaction() {
        this.getEm().joinTransaction();
    }

    public Object getDelegate() {
        return this.getEm().getDelegate();
    }

    public EntityTransaction getTransaction() {
        return this.getEm().getTransaction();
    }

    public Metamodel getMetamodel() {
        return this.getEm().getMetamodel();
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        return this.getEm().getEntityGraph(graphName);
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        return this.getEm().getEntityGraphs(entityClass);
    }
}

