/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.jdbc.JdbcUtils;
import com.appslandia.common.jdbc.LikeType;
import com.appslandia.common.jdbc.NonUniqueSqlException;
import com.appslandia.common.jdbc.ResultSetHandler;
import com.appslandia.common.jdbc.ResultSetImpl;
import com.appslandia.common.jdbc.ResultSetMapper;
import com.appslandia.common.jdbc.Sql;
import com.appslandia.common.jdbc.SqlLikeEscaper;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.IOUtils;
import com.appslandia.common.utils.NormalizeUtils;
import com.appslandia.common.utils.ObjectUtils;
import com.appslandia.common.utils.TagUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class StatementImpl
implements PreparedStatement {
    protected final Sql sql;
    protected final PreparedStatement stat;

    public StatementImpl(PreparedStatement stat) {
        AssertUtils.assertFalse(stat instanceof StatementImpl);
        this.stat = AssertUtils.assertNotNull(stat);
        this.sql = null;
    }

    public StatementImpl(Connection conn, String sql) throws SQLException {
        this.stat = conn.prepareStatement(sql);
        this.sql = null;
    }

    public StatementImpl(Connection conn, String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.stat = conn.prepareStatement(sql, resultSetType, resultSetConcurrency);
        this.sql = null;
    }

    public StatementImpl(Connection conn, Sql sql) throws SQLException {
        this.stat = conn.prepareStatement(sql.getTranslatedSql());
        this.sql = sql;
    }

    public StatementImpl(Connection conn, Sql sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        this.stat = conn.prepareStatement(sql.getTranslatedSql(), resultSetType, resultSetConcurrency);
        this.sql = sql;
    }

    public StatementImpl(Connection conn, Sql sql, boolean returnGeneratedKey) throws SQLException {
        this.stat = conn.prepareStatement(sql.getTranslatedSql(), returnGeneratedKey ? 1 : 2);
        this.sql = sql;
    }

    protected Sql getSql() {
        return AssertUtils.assertNotNull(this.sql, "sql is required.");
    }

    public int executeGeneratedKey() throws SQLException {
        long seq = this.executeGeneratedKeyLong();
        if (seq > Integer.MAX_VALUE) {
            throw new ArithmeticException("executeGeneratedKey");
        }
        return (int)seq;
    }

    public long executeGeneratedKeyLong() throws SQLException {
        this.stat.executeUpdate();
        try (ResultSet rs = this.stat.getGeneratedKeys();){
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
        }
        throw new SQLException("executeGeneratedKeyLong");
    }

    public <K> Map<String, K> executeMapNameToId(String nameKeyColumn, String idValueColumn) throws SQLException {
        return this.executeMapNameToId(nameKeyColumn, idValueColumn, new LinkedHashMap());
    }

    public <K> Map<String, K> executeMapNameToId(String nameKeyColumn, String idValueColumn, Map<String, K> map) throws SQLException {
        return JdbcUtils.executeMap(this, rs -> NormalizeUtils.keyValue(rs.getString(nameKeyColumn)), rs -> ObjectUtils.cast(rs.getObject(idValueColumn)), map);
    }

    public <K, V> Map<K, V> executeMap(ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper) throws SQLException {
        return this.executeMap(keyMapper, valueMapper, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        return JdbcUtils.executeMap(this, keyMapper, valueMapper, map);
    }

    public <K, V> Map<K, V> executeMap(String keyColumn, String valueColumn) throws SQLException {
        return this.executeMap(keyColumn, valueColumn, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        return JdbcUtils.executeMap(this, keyColumn, valueColumn, map);
    }

    public <T> List<T> executeList(ResultSetMapper<T> mapper) throws SQLException {
        return this.executeList(mapper, new ArrayList());
    }

    public <T> List<T> executeList(ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        return JdbcUtils.executeList(this, mapper, list);
    }

    public <T> T executeSingle(ResultSetMapper<T> mapper) throws SQLException {
        return JdbcUtils.executeSingle(this, mapper);
    }

    public <T> T executeScalar() throws SQLException {
        return (T)this.executeSingle(rs -> ObjectUtils.cast(rs.getObject(1)));
    }

    public void executeQuery(ResultSetHandler handler) throws Exception {
        try (ResultSetImpl rs = this.executeQuery();){
            while (rs.next()) {
                handler.handle(rs);
            }
        }
    }

    public void executeStream(String streamLabel, OutputStream os, ResultSetHandler handler) throws Exception {
        try (ResultSetImpl rs = this.executeQuery();){
            boolean rsRead = false;
            while (rs.next()) {
                if (rsRead) {
                    throw new NonUniqueSqlException();
                }
                rsRead = true;
                if (handler != null) {
                    handler.handle(rs);
                }
                InputStream is = rs.getBinaryStream(streamLabel);
                try {
                    IOUtils.copy(is, os);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
    }

    public void executeStream(String streamLabel, Writer w, ResultSetHandler handler) throws Exception {
        try (ResultSetImpl rs = this.executeQuery();){
            boolean rsRead = false;
            while (rs.next()) {
                if (rsRead) {
                    throw new NonUniqueSqlException();
                }
                rsRead = true;
                if (handler != null) {
                    handler.handle(rs);
                }
                Reader r = rs.getCharacterStream(streamLabel);
                try {
                    IOUtils.copy(r, w);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
        }
    }

    public void executeNStream(String streamLabel, Writer w, ResultSetHandler handler) throws Exception {
        try (ResultSetImpl rs = this.executeQuery();){
            boolean rsRead = false;
            while (rs.next()) {
                if (rsRead) {
                    throw new NonUniqueSqlException();
                }
                rsRead = true;
                if (handler != null) {
                    handler.handle(rs);
                }
                Reader r = rs.getNCharacterStream(streamLabel);
                try {
                    IOUtils.copy(r, w);
                }
                finally {
                    if (r == null) continue;
                    r.close();
                }
            }
        }
    }

    public void setLikeTag(String parameterName, String tag) throws SQLException {
        this.setLike(parameterName, TagUtils.wrapTag(tag));
    }

    public void setNLikeTag(String parameterName, String tag) throws SQLException {
        this.setNLike(parameterName, TagUtils.wrapTag(tag));
    }

    public void setLike(String parameterName, String value) throws SQLException {
        this.setString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.CONTAINS));
    }

    public void setLikeStart(String parameterName, String value) throws SQLException {
        this.setString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.STARTS_WITH));
    }

    public void setLikeEnd(String parameterName, String value) throws SQLException {
        this.setString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.ENDS_WITH));
    }

    public void setNLike(String parameterName, String value) throws SQLException {
        this.setNString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.CONTAINS));
    }

    public void setNLikeStart(String parameterName, String value) throws SQLException {
        this.setNString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.STARTS_WITH));
    }

    public void setNLikeEnd(String parameterName, String value) throws SQLException {
        this.setNString(parameterName, SqlLikeEscaper.toLikePattern(value, LikeType.ENDS_WITH));
    }

    public void setLikeAny(String parameterName, String[] values) throws SQLException {
        this.setLikeAny(parameterName, values, LikeType.CONTAINS, null);
    }

    public void setLikeAnyStart(String parameterName, String[] values) throws SQLException {
        this.setLikeAny(parameterName, values, LikeType.STARTS_WITH, null);
    }

    public void setLikeAnyEnd(String parameterName, String[] values) throws SQLException {
        this.setLikeAny(parameterName, values, LikeType.ENDS_WITH, null);
    }

    public void setLikeAny(String parameterName, String[] values, LikeType likeType, String falsePattern) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setString(Sql.toParamName(parameterName, i), i < values.length ? SqlLikeEscaper.toLikePattern(values[i], likeType) : falsePattern);
        }
    }

    public void setNLikeAny(String parameterName, String[] values) throws SQLException {
        this.setNLikeAny(parameterName, values, LikeType.CONTAINS, null);
    }

    public void setNLikeAnyStart(String parameterName, String[] values) throws SQLException {
        this.setNLikeAny(parameterName, values, LikeType.STARTS_WITH, null);
    }

    public void setNLikeAnyEnd(String parameterName, String[] values) throws SQLException {
        this.setNLikeAny(parameterName, values, LikeType.ENDS_WITH, null);
    }

    public void setNLikeAny(String parameterName, String[] values, LikeType likeType, String falsePattern) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setNString(Sql.toParamName(parameterName, i), i < values.length ? SqlLikeEscaper.toLikePattern(values[i], likeType) : falsePattern);
        }
    }

    public void setStringArray(String parameterName, String[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setString(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setNStringArray(String parameterName, String[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setNString(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setByteArray(String parameterName, byte[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setByte(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setByte2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setShortArray(String parameterName, short[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setShort(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setShort2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setIntArray(String parameterName, int[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setInt(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setInt2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setLongArray(String parameterName, long[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setLong(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setLong2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setFloatArray(String parameterName, float[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setFloat(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setFloat2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setDoubleArray(String parameterName, double[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            if (i < values.length) {
                this.setDouble(Sql.toParamName(parameterName, i), values[i]);
                continue;
            }
            this.setDouble2(Sql.toParamName(parameterName, i), null);
        }
    }

    public void setBigDecimalArray(String parameterName, BigDecimal[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setBigDecimal(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setDateArray(String parameterName, Date[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setDate(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setTimestampArray(String parameterName, Timestamp[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setTimestamp(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setTimeArray(String parameterName, Time[] values) throws SQLException {
        int arrayLen = this.getSql().getArrayLen(parameterName);
        AssertUtils.assertTrue(values.length <= arrayLen);
        for (int i = 0; i < arrayLen; ++i) {
            this.setTime(Sql.toParamName(parameterName, i), i < values.length ? values[i] : null);
        }
    }

    public void setBoolean2(String parameterName, Boolean value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, -7);
        } else {
            this.setBoolean(parameterName, (boolean)value);
        }
    }

    public void setByte2(String parameterName, Byte value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, -6);
        } else {
            this.setByte(parameterName, (byte)value);
        }
    }

    public void setShort2(String parameterName, Short value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, 5);
        } else {
            this.setShort(parameterName, (short)value);
        }
    }

    public void setInt2(String parameterName, Integer value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, 4);
        } else {
            this.setInt(parameterName, (int)value);
        }
    }

    public void setLong2(String parameterName, Long value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, -5);
        } else {
            this.setLong(parameterName, (long)value);
        }
    }

    public void setFloat2(String parameterName, Float value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, 7);
        } else {
            this.setFloat(parameterName, value.floatValue());
        }
    }

    public void setDouble2(String parameterName, Double value) throws SQLException {
        if (value == null) {
            this.setNull(parameterName, 8);
        } else {
            this.setDouble(parameterName, (double)value);
        }
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBoolean(index, x);
        }
    }

    public void setString(String parameterName, String x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setString(index, x);
        }
    }

    public void setNString(String parameterName, String value) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNString(index, value);
        }
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setByte(index, x);
        }
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBytes(index, x);
        }
    }

    public void setShort(String parameterName, short x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setShort(index, x);
        }
    }

    public void setInt(String parameterName, int x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setInt(index, x);
        }
    }

    public void setLong(String parameterName, long x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setLong(index, x);
        }
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setFloat(index, x);
        }
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setDouble(index, x);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBigDecimal(index, x);
        }
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setDate(index, x, cal);
        }
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setDate(index, x);
        }
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setTimestamp(index, x);
        }
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setTimestamp(index, x, cal);
        }
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setTime(index, x, cal);
        }
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setTime(index, x);
        }
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNull(index, sqlType, typeName);
        }
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNull(index, sqlType);
        }
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setObject(index, x);
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setObject(index, x, targetSqlType, scaleOrLength);
        }
    }

    public void setObject(String parameterName, Object x, SQLType targetSqlType) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setObject(index, x, targetSqlType);
        }
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setObject(index, x, targetSqlType);
        }
    }

    public void setObject(String parameterName, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setObject(index, x, targetSqlType, scaleOrLength);
        }
    }

    public void setURL(String parameterName, URL x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setURL(index, x);
        }
    }

    public void setArray(String parameterName, Array x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setArray(index, x);
        }
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setSQLXML(index, xmlObject);
        }
    }

    public void setRef(String parameterName, Ref x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setRef(index, x);
        }
    }

    public void setRowId(String parameterName, RowId x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setRowId(index, x);
        }
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setClob(index, reader, length);
        }
    }

    public void setClob(String parameterName, Clob x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setClob(index, x);
        }
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setClob(index, reader);
        }
    }

    public void setNClob(String parameterName, NClob value) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNClob(index, value);
        }
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNClob(index, reader, length);
        }
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNClob(index, reader);
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setAsciiStream(index, x, length);
        }
    }

    public void setAsciiStream(String parameterName, InputStream x, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setAsciiStream(index, x, length);
        }
    }

    public void setAsciiStream(String parameterName, InputStream x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setAsciiStream(index, x);
        }
    }

    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setCharacterStream(index, reader, length);
        }
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setCharacterStream(index, reader, length);
        }
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setCharacterStream(index, reader);
        }
    }

    public void setNCharacterStream(String parameterName, Reader value, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNCharacterStream(index, value, length);
        }
    }

    public void setNCharacterStream(String parameterName, Reader value) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setNCharacterStream(index, value);
        }
    }

    @Deprecated
    public void setUnicodeStream(String parameterName, InputStream x, int length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setUnicodeStream(index, x, length);
        }
    }

    public void setBlob(String parameterName, Blob x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBlob(index, x);
        }
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBlob(index, inputStream);
        }
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBlob(index, inputStream, length);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, long length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBinaryStream(index, x, length);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBinaryStream(index, x);
        }
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        for (int index : this.getSql().getIndexes(parameterName)) {
            this.stat.setBinaryStream(index, x, length);
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        return this.stat.executeUpdate();
    }

    @Override
    public long executeLargeUpdate() throws SQLException {
        return this.stat.executeLargeUpdate();
    }

    @Override
    public boolean execute() throws SQLException {
        return this.stat.execute();
    }

    @Override
    public ResultSetImpl executeQuery() throws SQLException {
        return new ResultSetImpl(this.stat.executeQuery());
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.stat.setBoolean(parameterIndex, x);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.stat.setString(parameterIndex, x);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.stat.setNString(parameterIndex, value);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.stat.setByte(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.stat.setBytes(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.stat.setShort(parameterIndex, x);
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.stat.setInt(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.stat.setLong(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.stat.setFloat(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.stat.setDouble(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.stat.setBigDecimal(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.stat.setDate(parameterIndex, x, cal);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.stat.setDate(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.stat.setTimestamp(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.stat.setTimestamp(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.stat.setTime(parameterIndex, x, cal);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.stat.setTime(parameterIndex, x);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.stat.setNull(parameterIndex, sqlType, typeName);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.stat.setNull(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.stat.setObject(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.stat.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType) throws SQLException {
        this.stat.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.stat.setObject(parameterIndex, x, targetSqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, SQLType targetSqlType, int scaleOrLength) throws SQLException {
        this.stat.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.stat.setURL(parameterIndex, x);
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.stat.setArray(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.stat.setSQLXML(parameterIndex, xmlObject);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.stat.setRef(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.stat.setRowId(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stat.setClob(parameterIndex, reader, length);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.stat.setClob(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.stat.setClob(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.stat.setNClob(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stat.setNClob(parameterIndex, reader, length);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.stat.setNClob(parameterIndex, reader);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stat.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.stat.setAsciiStream(parameterIndex, x, length);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.stat.setAsciiStream(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.stat.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.stat.setCharacterStream(parameterIndex, reader, length);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.stat.setCharacterStream(parameterIndex, reader);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.stat.setNCharacterStream(parameterIndex, value, length);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.stat.setNCharacterStream(parameterIndex, value);
    }

    @Override
    @Deprecated
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stat.setUnicodeStream(parameterIndex, x, length);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.stat.setBlob(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.stat.setBlob(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.stat.setBlob(parameterIndex, inputStream, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.stat.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.stat.setBinaryStream(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.stat.setBinaryStream(parameterIndex, x, length);
    }

    @Override
    public void addBatch() throws SQLException {
        this.stat.addBatch();
    }

    @Override
    public void clearParameters() throws SQLException {
        this.stat.clearParameters();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.stat.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.stat.getParameterMetaData();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.stat.executeLargeUpdate(sql, columnIndexes);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.stat.executeLargeUpdate(sql, columnNames);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.stat.executeLargeUpdate(sql);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stat.executeLargeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.stat.executeUpdate(sql, columnIndexes);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stat.executeUpdate(sql, autoGeneratedKeys);
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.stat.executeUpdate(sql);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.stat.executeUpdate(sql, columnNames);
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.stat.execute(sql);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.stat.execute(sql, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.stat.execute(sql, columnIndexes);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.stat.execute(sql, columnNames);
    }

    @Override
    public int[] executeBatch() throws SQLException {
        return this.stat.executeBatch();
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        return this.stat.executeLargeBatch();
    }

    @Override
    public ResultSetImpl executeQuery(String sql) throws SQLException {
        return new ResultSetImpl(this.stat.executeQuery(sql));
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.stat.setQueryTimeout(seconds);
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.stat.setCursorName(name);
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.stat.setEscapeProcessing(enable);
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.stat.setFetchDirection(direction);
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.stat.setFetchSize(rows);
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        this.stat.setLargeMaxRows(max);
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        this.stat.setMaxFieldSize(max);
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.stat.setMaxRows(max);
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        this.stat.setPoolable(poolable);
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        return this.stat.getLargeUpdateCount();
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return this.stat.getUpdateCount();
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.stat.getQueryTimeout();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.stat.addBatch(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.stat.cancel();
    }

    @Override
    public void clearBatch() throws SQLException {
        this.stat.clearBatch();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.stat.clearWarnings();
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.stat.closeOnCompletion();
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.stat.getConnection();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.stat.getFetchDirection();
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.stat.getFetchSize();
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        return this.stat.getGeneratedKeys();
    }

    @Override
    public long getLargeMaxRows() throws SQLException {
        return this.stat.getLargeMaxRows();
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return this.stat.getMaxFieldSize();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.stat.getMaxRows();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.stat.getMoreResults();
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return this.stat.getMoreResults(current);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.stat.getResultSet();
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return this.stat.getResultSetConcurrency();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return this.stat.getResultSetHoldability();
    }

    @Override
    public int getResultSetType() throws SQLException {
        return this.stat.getResultSetType();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.stat.getWarnings();
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.stat.isCloseOnCompletion();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.stat.isClosed();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return this.stat.isPoolable();
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        return this.stat.isWrapperFor(arg0);
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        return this.stat.unwrap(arg0);
    }

    @Override
    public void close() throws SQLException {
        this.stat.close();
    }
}

