/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.jdbc.LikeType;
import com.appslandia.common.utils.ArrayUtils;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.stream.IntStream;

public class SqlLikeEscaper {
    final char escapeSignChar;
    final char[] charsToEscape;
    private static volatile SqlLikeEscaper __default;
    private static volatile char __escapeSignChar;
    private static volatile char[] __charsToEscape;
    private static final Object MUTEX;

    public SqlLikeEscaper(char escapeSignChar, char[] charsToEscape) {
        AssertUtils.assertNotNull(charsToEscape);
        this.escapeSignChar = escapeSignChar;
        this.charsToEscape = (char[])charsToEscape.clone();
    }

    public String escape(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(value.length() + value.length() / 5);
        sb.append(value);
        int i = -1;
        block0: while (++i != sb.length()) {
            for (char c : this.charsToEscape) {
                if (c != sb.charAt(i)) continue;
                sb.insert(i, this.escapeSignChar);
                ++i;
                continue block0;
            }
        }
        return sb.toString();
    }

    public boolean hasEscapeSignChar(String value) {
        if (value == null) {
            return false;
        }
        return IntStream.range(0, value.length() - 1).anyMatch(index -> value.charAt(index) == SqlLikeEscaper.getEscapeSignChar());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SqlLikeEscaper getDefault() {
        SqlLikeEscaper obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = new SqlLikeEscaper(SqlLikeEscaper.getEscapeSignChar(), SqlLikeEscaper.getCharsToEscape());
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(SqlLikeEscaper impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __default = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("SqlLikeEscaper.__default must be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getEscapeSignChar() {
        int chr = __escapeSignChar;
        if (chr == 0) {
            Object object = MUTEX;
            synchronized (object) {
                chr = __escapeSignChar;
                if (chr == 0) {
                    chr = 92;
                    __escapeSignChar = (char)92;
                }
            }
        }
        return (char)chr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setEscapeSignChar(char impl) {
        if (__escapeSignChar == '\u0000') {
            Object object = MUTEX;
            synchronized (object) {
                if (__escapeSignChar == '\u0000') {
                    __escapeSignChar = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("SqlLikeEscaper.__escapeSignChar must be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getCharsToEscape() {
        char[] obj = __charsToEscape;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __charsToEscape;
                if (__charsToEscape == null) {
                    obj = new char[]{'%', '_'};
                    __charsToEscape = obj;
                }
            }
        }
        return (char[])obj.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCharsToEscape(char[] impl) {
        if (__charsToEscape == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__charsToEscape == null) {
                    __charsToEscape = ArrayUtils.copy(impl);
                    return;
                }
            }
        }
        throw new IllegalStateException("SqlLikeEscaper.__charsToEscape must be null.");
    }

    public static String toLikePattern(String value, LikeType likeType) {
        AssertUtils.assertNotNull(likeType);
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        if (likeType == LikeType.CONTAINS) {
            return "%" + SqlLikeEscaper.getDefault().escape(value) + "%";
        }
        if (likeType == LikeType.STARTS_WITH) {
            return SqlLikeEscaper.getDefault().escape(value) + "%";
        }
        return "%" + SqlLikeEscaper.getDefault().escape(value);
    }

    static {
        MUTEX = new Object();
    }
}

