/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.base.InitializeException;
import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.base.Out;
import com.appslandia.common.utils.AssertUtils;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class Sql
extends InitializeObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_ARRAY_MAX_LENGTH = 32;
    private String name;
    private String sql;
    private Map<String, Integer> arrayLens;
    private String translatedSql;
    private Map<String, int[]> indexesMap;
    private static volatile char __paramPrefix;
    private static final Object MUTEX;

    public Sql() {
    }

    public Sql(String sql) {
        this.sql = sql;
    }

    public Sql sql(String sql) {
        this.assertNotInitialized();
        this.sql = sql;
        return this;
    }

    @Override
    public Sql initialize() throws InitializeException {
        super.initialize();
        return this;
    }

    @Override
    protected void init() throws Exception {
        AssertUtils.assertNotNull(this.sql, "sql is required.");
        this.translateSql();
    }

    public Sql arrayLen(String parameterName, int maxLength) {
        this.assertNotInitialized();
        AssertUtils.assertTrue(maxLength > 0, "maxLength is required.");
        if (this.arrayLens == null) {
            this.arrayLens = new HashMap<String, Integer>();
        }
        this.arrayLens.put(parameterName, maxLength);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private void translateSql() {
        sb = new StringBuilder(this.sql);
        indexesMap = new LinkedHashMap<String, int[]>();
        start = 0;
        index = 0;
        while (true) lbl-1000:
        // 6 sources

        {
            for (paramIdx = start; paramIdx < sb.length() - 1 && sb.charAt(paramIdx) != Sql.getParamPrefix(); ++paramIdx) {
            }
            if (paramIdx >= sb.length() - 1) break;
            paramEnd = new Out<Integer>();
            paramName = new Out<String>();
            isParamContext = Sql.isParamContext(sb, paramIdx, paramEnd, paramName);
            if (!isParamContext) {
                start = paramIdx + 1;
                ** continue;
            }
            fieldIdx = new Out<Integer>();
            fieldName = new Out<String>();
            isInContext = Sql.isContext(sb, paramIdx, "IN", fieldIdx, fieldName);
            isLikeAnyContext = Sql.isContext(sb, paramIdx, "LIKE_ANY", fieldIdx, fieldName);
            isArrayParam = isInContext != false || isLikeAnyContext != false;
            v0 = arrayLen = this.arrayLens == null ? null : this.arrayLens.get(paramName.value);
            if (arrayLen != null) {
                if (!isArrayParam) {
                    throw new IllegalArgumentException("Array parameter is not found (name=" + paramName + ")");
                }
            } else if (isArrayParam) {
                arrayLen = 32;
                if (this.arrayLens == null) {
                    this.arrayLens = new HashMap<String, Integer>();
                }
                this.arrayLens.put((String)paramName.value, arrayLen);
            }
            if (!isArrayParam) {
                sb.replace(paramIdx, (Integer)paramEnd.value + 1, "?");
                this.putIndex(indexesMap, (String)paramName.value, ++index);
                start = paramIdx + 1;
                ** continue;
            }
            if (isInContext) {
                sb.replace(paramIdx, (Integer)paramEnd.value + 1, "()");
                for (subIdx = 0; subIdx < arrayLen; ++subIdx) {
                    if (subIdx == 0) {
                        sb.insert(paramIdx + 1, '?');
                    } else {
                        sb.insert(paramIdx + 1, "?, ");
                    }
                    this.putIndex(indexesMap, Sql.toParamName((String)paramName.value, subIdx), ++index);
                }
                start = paramIdx + 1;
                ** continue;
            }
            sb.delete((Integer)fieldIdx.value, (Integer)paramEnd.value + 1);
            for (subIdx = 0; subIdx < arrayLen; ++subIdx) {
                if (subIdx == 0) {
                    sb.insert((int)((Integer)fieldIdx.value), String.format("%s LIKE ?", new Object[]{fieldName.value}));
                } else {
                    sb.insert((int)((Integer)fieldIdx.value), String.format("%s LIKE ? OR ", new Object[]{fieldName.value}));
                }
                this.putIndex(indexesMap, Sql.toParamName((String)paramName.value, subIdx), ++index);
            }
            start = (Integer)fieldIdx.value + 1;
        }
        this.translatedSql = sb.toString();
        this.indexesMap = Collections.unmodifiableMap(indexesMap);
    }

    private void putIndex(Map<String, int[]> indexesMap, String paramName, int index) {
        int[] indexes = indexesMap.get(paramName);
        if (indexes == null) {
            indexes = new int[]{index};
        } else {
            indexes = Arrays.copyOf(indexes, indexes.length + 1);
            indexes[indexes.length - 1] = index;
        }
        indexesMap.put(paramName, indexes);
    }

    public String getName() {
        this.initialize();
        return this.name;
    }

    public Sql setName(String name) {
        this.assertNotInitialized();
        this.name = name;
        return this;
    }

    public String getSql() {
        this.initialize();
        return this.sql;
    }

    public String getTranslatedSql() {
        this.initialize();
        return this.translatedSql;
    }

    public int[] getIndexes(String parameterName) {
        this.initialize();
        int[] indexes = this.indexesMap.get(parameterName);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter is not found (name=" + parameterName + ")");
        }
        return indexes;
    }

    public int getArrayLen(String parameterName) {
        Integer len;
        this.initialize();
        Integer n = len = this.arrayLens != null ? this.arrayLens.get(parameterName) : null;
        if (len == null) {
            throw new IllegalArgumentException("Array parameter is not found (name=" + parameterName + ")");
        }
        return len;
    }

    private static boolean isContext(StringBuilder sb, int paramIdx, String context, Out<Integer> fieldIdx, Out<String> fieldName) {
        int h;
        int k;
        int j;
        int i;
        for (i = paramIdx - 1; i >= 0 && Character.isWhitespace(sb.charAt(i)); --i) {
        }
        if (i < 0) {
            return false;
        }
        for (j = i; j >= 0 && !Character.isWhitespace(sb.charAt(j)); --j) {
        }
        if (!sb.substring(j + 1, i + 1).equalsIgnoreCase(context)) {
            return false;
        }
        if (j < 0) {
            return false;
        }
        for (k = j; k >= 0 && Character.isWhitespace(sb.charAt(k)); --k) {
        }
        if (k < 0) {
            return false;
        }
        for (h = k; h >= 0 && !Character.isWhitespace(sb.charAt(h)) && sb.charAt(h) != '('; --h) {
        }
        fieldName.value = sb.substring(h + 1, k + 1);
        if (((String)fieldName.value).isEmpty()) {
            return false;
        }
        fieldIdx.value = h + 1;
        return true;
    }

    private static boolean isParamContext(StringBuilder sb, int paramIdx, Out<Integer> paramEnd, Out<String> paramName) {
        int k;
        for (k = paramIdx + 1; k < sb.length() && Sql.isParamChar(sb.charAt(k)); ++k) {
        }
        if (k == paramIdx + 1) {
            return false;
        }
        paramName.value = sb.substring(paramIdx + 1, k);
        paramEnd.value = k - 1;
        return true;
    }

    public static String toParamName(String parameterName, int subIdx) {
        return parameterName + "__" + subIdx;
    }

    private static boolean isParamChar(char chr) {
        return 'a' <= chr && chr <= 'z' || 'A' <= chr && chr <= 'Z' || '0' <= chr && chr <= '9' || chr == '_';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char getParamPrefix() {
        int chr = __paramPrefix;
        if (chr == 0) {
            Object object = MUTEX;
            synchronized (object) {
                chr = __paramPrefix;
                if (chr == 0) {
                    chr = 58;
                    __paramPrefix = (char)58;
                }
            }
        }
        return (char)chr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setParamPrefix(char impl) {
        if (__paramPrefix == '\u0000') {
            Object object = MUTEX;
            synchronized (object) {
                if (__paramPrefix == '\u0000') {
                    __paramPrefix = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("Sql.__paramPrefix must be null.");
    }

    static {
        MUTEX = new Object();
    }
}

