/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.jdbc.NonUniqueSqlException;
import com.appslandia.common.jdbc.ResultSetImpl;
import com.appslandia.common.jdbc.ResultSetMapper;
import com.appslandia.common.jdbc.StatementImpl;
import com.appslandia.common.utils.ObjectUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class JdbcUtils {
    public static void rollback(Connection conn) throws SQLException {
        if (conn != null) {
            conn.rollback();
        }
    }

    public static void setAutoCommit(Connection conn) throws SQLException {
        if (conn != null) {
            conn.setAutoCommit(true);
        }
    }

    public static void closeQuietly(AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> T executeSingle(StatementImpl stat, ResultSetMapper<T> mapper) throws SQLException {
        try (ResultSetImpl rs = stat.executeQuery();){
            T t = JdbcUtils.executeSingle(rs, mapper);
            return t;
        }
    }

    public static <T> T executeSingle(ResultSetImpl rs, ResultSetMapper<T> mapper) throws SQLException {
        T t = null;
        boolean rsRead = false;
        while (rs.next()) {
            if (rsRead) {
                throw new NonUniqueSqlException();
            }
            rsRead = true;
            t = mapper.map(rs);
        }
        return t;
    }

    public static <T> List<T> executeList(StatementImpl stat, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        try (ResultSetImpl rs = stat.executeQuery();){
            List<T> list2 = JdbcUtils.executeList(rs, mapper, list);
            return list2;
        }
    }

    public static <T> List<T> executeList(ResultSetImpl rs, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        while (rs.next()) {
            T t = mapper.map(rs);
            list.add(t);
        }
        return list;
    }

    public static <K, V> Map<K, V> executeMap(StatementImpl stat, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        try (ResultSetImpl rs = stat.executeQuery();){
            Map<K, V> map2 = JdbcUtils.executeMap((ResultSet)rs, keyColumn, valueColumn, map);
            return map2;
        }
    }

    public static <K, V> Map<K, V> executeMap(ResultSet rs, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        while (rs.next()) {
            Object k = ObjectUtils.cast(rs.getObject(keyColumn));
            Object v = ObjectUtils.cast(rs.getObject(valueColumn));
            map.put(k, v);
        }
        return map;
    }

    public static <K, V> Map<K, V> executeMap(StatementImpl stat, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        try (ResultSetImpl rs = stat.executeQuery();){
            Map<K, V> map2 = JdbcUtils.executeMap(rs, keyMapper, valueMapper, map);
            return map2;
        }
    }

    public static <K, V> Map<K, V> executeMap(ResultSetImpl rs, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        while (rs.next()) {
            K k = keyMapper.map(rs);
            V v = valueMapper.map(rs);
            map.put(k, v);
        }
        return map;
    }

    public static String[] getColumnLabels(ResultSet rs) throws SQLException {
        ResultSetMetaData md = rs.getMetaData();
        ArrayList<String> labels = new ArrayList<String>(md.getColumnCount());
        for (int idx = 1; idx <= md.getColumnCount(); ++idx) {
            labels.add(md.getColumnLabel(idx));
        }
        return labels.toArray(new String[labels.size()]);
    }
}

