/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.jdbc.JdbcUtils;
import com.appslandia.common.jdbc.ResultSetHandler;
import com.appslandia.common.jdbc.ResultSetImpl;
import com.appslandia.common.jdbc.ResultSetMapper;
import com.appslandia.common.jdbc.Sql;
import com.appslandia.common.jdbc.StatementImpl;
import com.appslandia.common.threading.ThreadLocalStorage;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.NormalizeUtils;
import com.appslandia.common.utils.ObjectUtils;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;

public class ConnectionImpl
implements Connection {
    protected final Connection conn;
    protected final String dsName;
    protected ConnectionImpl outer;
    private static final ThreadLocalStorage<ConnectionImpl> CONNECTION_HOLDER = new ThreadLocalStorage();

    public ConnectionImpl(DataSource dataSource, String dsName) throws SQLException {
        ConnectionImpl outer = CONNECTION_HOLDER.get();
        if (outer != null) {
            this.outer = outer;
        }
        this.conn = dataSource.getConnection();
        CONNECTION_HOLDER.set(this);
        this.dsName = AssertUtils.assertNotNull(dsName, "dsName must be not null.");
    }

    public ConnectionImpl(DataSource dataSource) throws SQLException {
        this(dataSource, "");
    }

    public String getDsName() {
        return this.dsName;
    }

    public int executeUpdate(String sql) throws SQLException {
        try (Statement stat = this.conn.createStatement();){
            int n = stat.executeUpdate(sql);
            return n;
        }
    }

    public <K> Map<String, K> executeMapNameToId(String sql, String nameKeyColumn, String idValueColumn) throws SQLException {
        return this.executeMapNameToId(sql, nameKeyColumn, idValueColumn, new LinkedHashMap());
    }

    public <K> Map<String, K> executeMapNameToId(String sql, String nameKeyColumn, String idValueColumn, Map<String, K> map) throws SQLException {
        return this.executeMap(sql, (ResultSetImpl rs) -> NormalizeUtils.keyValue(rs.getString(nameKeyColumn)), (ResultSetImpl rs) -> ObjectUtils.cast(rs.getObject(idValueColumn)), map);
    }

    public <K> Map<String, K> executeMapNameToId(String sql, Map<String, Object> params, String nameKeyColumn, String idValueColumn) throws SQLException {
        return this.executeMapNameToId(sql, params, nameKeyColumn, idValueColumn, new LinkedHashMap());
    }

    public <K> Map<String, K> executeMapNameToId(String sql, Map<String, Object> params, String nameKeyColumn, String idValueColumn, Map<String, K> map) throws SQLException {
        return this.executeMap(sql, params, (ResultSetImpl rs) -> NormalizeUtils.keyValue(rs.getString(nameKeyColumn)), (ResultSetImpl rs) -> ObjectUtils.cast(rs.getObject(idValueColumn)), map);
    }

    public <K, V> Map<K, V> executeMap(String sql, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper) throws SQLException {
        return this.executeMap(sql, keyMapper, valueMapper, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        try (Statement stat = this.conn.createStatement();){
            Map<K, V> map2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                map2 = JdbcUtils.executeMap(rs, keyMapper, valueMapper, map);
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String sql, Map<String, Object> params, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper) throws SQLException {
        return this.executeMap(sql, params, keyMapper, valueMapper, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, Map<String, Object> params, ResultSetMapper<K> keyMapper, ResultSetMapper<V> valueMapper, Map<K, V> map) throws SQLException {
        Sql pSql = new Sql(sql);
        try (StatementImpl stat = new StatementImpl(this.conn, pSql);){
            Map<K, V> map2;
            block12: {
                if (params != null) {
                    ConnectionImpl.setParameters(stat, params);
                }
                ResultSetImpl rs = stat.executeQuery();
                try {
                    map2 = JdbcUtils.executeMap(rs, keyMapper, valueMapper, map);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String sql, String keyColumn, String valueColumn) throws SQLException {
        return this.executeMap(sql, keyColumn, valueColumn, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        try (Statement stat = this.conn.createStatement();){
            Map<K, V> map2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                map2 = JdbcUtils.executeMap((ResultSet)rs, keyColumn, valueColumn, map);
            }
            return map2;
        }
    }

    public <K, V> Map<K, V> executeMap(String sql, Map<String, Object> params, String keyColumn, String valueColumn) throws SQLException {
        return this.executeMap(sql, params, keyColumn, valueColumn, new LinkedHashMap());
    }

    public <K, V> Map<K, V> executeMap(String sql, Map<String, Object> params, String keyColumn, String valueColumn, Map<K, V> map) throws SQLException {
        Sql pSql = new Sql(sql);
        try (StatementImpl stat = new StatementImpl(this.conn, pSql);){
            Map<K, V> map2;
            block12: {
                if (params != null) {
                    ConnectionImpl.setParameters(stat, params);
                }
                ResultSetImpl rs = stat.executeQuery();
                try {
                    map2 = JdbcUtils.executeMap((ResultSet)rs, keyColumn, valueColumn, map);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return map2;
        }
    }

    public <T> List<T> executeList(String sql, ResultSetMapper<T> mapper) throws SQLException {
        return this.executeList(sql, mapper, new ArrayList());
    }

    public <T> List<T> executeList(String sql, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        try (Statement stat = this.conn.createStatement();){
            List<T> list2;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                list2 = JdbcUtils.executeList(rs, mapper, list);
            }
            return list2;
        }
    }

    public <T> List<T> executeList(String sql, Map<String, Object> params, ResultSetMapper<T> mapper) throws SQLException {
        return this.executeList(sql, params, mapper, new ArrayList());
    }

    public <T> List<T> executeList(String sql, Map<String, Object> params, ResultSetMapper<T> mapper, List<T> list) throws SQLException {
        Sql pSql = new Sql(sql);
        try (StatementImpl stat = new StatementImpl(this.conn, pSql);){
            List<T> list2;
            block12: {
                if (params != null) {
                    ConnectionImpl.setParameters(stat, params);
                }
                ResultSetImpl rs = stat.executeQuery();
                try {
                    list2 = JdbcUtils.executeList(rs, mapper, list);
                    if (rs == null) break block12;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return list2;
        }
    }

    public <T> T executeSingle(String sql, ResultSetMapper<T> mapper) throws SQLException {
        try (Statement stat = this.conn.createStatement();){
            T t;
            try (ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
                t = JdbcUtils.executeSingle(rs, mapper);
            }
            return t;
        }
    }

    public <T> T executeScalar(String sql) throws SQLException {
        return (T)this.executeSingle(sql, rs -> ObjectUtils.cast(rs.getObject(1)));
    }

    public void executeQuery(String sql, ResultSetHandler handler) throws Exception {
        try (Statement stat = this.conn.createStatement();
             ResultSetImpl rs = new ResultSetImpl(stat.executeQuery(sql));){
            while (rs.next()) {
                handler.handle(rs);
            }
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        return this.conn.prepareCall(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public StatementImpl prepareStatement(String sql) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql));
    }

    @Override
    public StatementImpl prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql, autoGeneratedKeys));
    }

    @Override
    public StatementImpl prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql, columnIndexes));
    }

    @Override
    public StatementImpl prepareStatement(String sql, String[] columnNames) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql, columnNames));
    }

    @Override
    public StatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency));
    }

    @Override
    public StatementImpl prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return new StatementImpl(this.conn.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability));
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return this.conn.createArrayOf(typeName, elements);
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return this.conn.createSQLXML();
    }

    @Override
    public Clob createClob() throws SQLException {
        return this.conn.createClob();
    }

    @Override
    public NClob createNClob() throws SQLException {
        return this.conn.createNClob();
    }

    @Override
    public Blob createBlob() throws SQLException {
        return this.conn.createBlob();
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.conn.createStatement();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.conn.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return this.conn.createStruct(typeName, attributes);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return this.conn.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return this.conn.setSavepoint(name);
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.conn.setNetworkTimeout(executor, milliseconds);
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.conn.setAutoCommit(autoCommit);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.conn.setCatalog(catalog);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.conn.setClientInfo(properties);
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        this.conn.setClientInfo(name, value);
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.conn.setHoldability(holdability);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.conn.setReadOnly(readOnly);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.conn.setSchema(schema);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.conn.setTransactionIsolation(level);
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.conn.setTypeMap(map);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.conn.getNetworkTimeout();
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.conn.getAutoCommit();
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.conn.getCatalog();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.conn.getClientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return this.conn.getClientInfo(name);
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.conn.getHoldability();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.conn.getMetaData();
    }

    @Override
    public String getSchema() throws SQLException {
        return this.conn.getSchema();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.conn.getTransactionIsolation();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return this.conn.getTypeMap();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.conn.getWarnings();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.conn.isClosed();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.conn.isReadOnly();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return this.conn.isValid(timeout);
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.conn.releaseSavepoint(savepoint);
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.conn.abort(executor);
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.conn.clearWarnings();
    }

    @Override
    public void commit() throws SQLException {
        this.conn.commit();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        return this.conn.nativeSQL(sql);
    }

    @Override
    public void rollback() throws SQLException {
        this.conn.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.conn.rollback(savepoint);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.conn.isWrapperFor(iface);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.conn.unwrap(iface);
    }

    @Override
    public void close() throws SQLException {
        if (!this.conn.isClosed()) {
            ConnectionImpl outer = this.outer;
            this.conn.close();
            this.outer = null;
            CONNECTION_HOLDER.set(outer);
        }
    }

    static void setParameters(StatementImpl stat, Map<String, Object> params) throws SQLException {
        for (Map.Entry<String, Object> param : params.entrySet()) {
            stat.setObject(param.getKey(), param.getValue());
        }
    }

    public static ConnectionImpl getCurrent() throws IllegalStateException {
        ConnectionImpl conn = CONNECTION_HOLDER.get();
        if (conn == null) {
            throw new IllegalStateException("No current connection found in the current thread.");
        }
        return conn;
    }

    public static boolean hasCurrent() {
        return CONNECTION_HOLDER.hasValue();
    }
}

