/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.jdbc;

import com.appslandia.common.jdbc.ConnScoped;
import com.appslandia.common.jdbc.ConnectionImpl;
import jakarta.interceptor.InvocationContext;
import java.io.Serializable;
import javax.sql.DataSource;

public abstract class ConnScopedInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Object intercept(InvocationContext context) throws Exception {
        ConnScoped connScoped = context.getMethod().getAnnotation(ConnScoped.class);
        ConnScoped.ConnType type = connScoped.value();
        if (type == ConnScoped.ConnType.REQUIRES_NEW) {
            try (ConnectionImpl newConn = new ConnectionImpl(this.getDataSource(connScoped.ds()));){
                Object object = context.proceed();
                return object;
            }
        }
        if (ConnectionImpl.hasCurrent()) {
            if (connScoped.ds().equals(ConnectionImpl.getCurrent().getDsName())) {
                return context.proceed();
            }
            try (ConnectionImpl newConn = new ConnectionImpl(this.getDataSource(connScoped.ds()));){
                Object object = context.proceed();
                return object;
            }
        }
        try (ConnectionImpl newConn = new ConnectionImpl(this.getDataSource(connScoped.ds()));){
            Object object = context.proceed();
            return object;
        }
    }

    protected abstract DataSource getDataSource(String var1);
}

