/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.geo;

import com.appslandia.common.geo.Direction;
import com.appslandia.common.geo.DistanceUnit;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.DecimalUtils;

public class GeoLocation {
    final double latitude;
    final double longitude;

    public GeoLocation(double latitude, double longitude) {
        this.latitude = latitude;
        this.longitude = longitude;
        AssertUtils.assertTrue(this.latitude >= -90.0 && this.latitude <= 90.0, "latitude is invalid [-90.0, 90.0]");
        AssertUtils.assertTrue(this.longitude >= -180.0 && this.longitude <= 180.0, "longitude is invalid [-180.0, 180.0]");
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public GeoLocation round(int scale) {
        return new GeoLocation(DecimalUtils.round(this.latitude, scale), DecimalUtils.round(this.longitude, scale));
    }

    public GeoLocation move(Direction direction, double distance, DistanceUnit unit) {
        AssertUtils.assertNotNull(direction);
        AssertUtils.assertNotNull(unit);
        double perdegLong = 0.014481249075311908;
        double perdegLat = 360.0 / (Math.cos(Math.toRadians(this.latitude)) * 24901.461);
        switch (direction) {
            case NORTH: {
                return new GeoLocation(this.latitude + DistanceUnit.MILE.convert(distance, unit) * perdegLong, this.longitude);
            }
            case SOUTH: {
                return new GeoLocation(this.latitude - DistanceUnit.MILE.convert(distance, unit) * perdegLong, this.longitude);
            }
            case EAST: {
                return new GeoLocation(this.latitude, this.longitude + DistanceUnit.MILE.convert(distance, unit) * perdegLat);
            }
            case WEST: {
                return new GeoLocation(this.latitude, this.longitude - DistanceUnit.MILE.convert(distance, unit) * perdegLat);
            }
        }
        throw new Error();
    }

    public double distanceTo(GeoLocation to, DistanceUnit unit) {
        AssertUtils.assertNotNull(to);
        AssertUtils.assertNotNull(unit);
        double rlt1 = Math.toRadians(this.latitude);
        double rlt2 = Math.toRadians(to.latitude);
        double rlg1 = Math.toRadians(this.longitude);
        double rlg2 = Math.toRadians(to.longitude);
        double h = Math.sin((rlt2 - rlt1) / 2.0) * Math.sin((rlt2 - rlt1) / 2.0) + Math.cos(rlt1) * Math.cos(rlt2) * Math.sin((rlg2 - rlg1) / 2.0) * Math.sin((rlg2 - rlg1) / 2.0);
        double d = 1.274201749118E7 * Math.asin(Math.sqrt(h));
        return unit.convert(d, DistanceUnit.METER);
    }

    public String toString() {
        return String.format("%.8f, %.8f", this.latitude, this.longitude);
    }
}

