/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.geo;

import com.appslandia.common.geo.Direction;
import com.appslandia.common.utils.DecimalUtils;

public class GeoDms {
    final int degrees;
    final int minutes;
    final double seconds;

    public GeoDms(int degrees, int minutes, double seconds) {
        this.degrees = degrees;
        this.minutes = minutes;
        this.seconds = seconds;
    }

    public GeoDms round(int secondsScale) {
        return new GeoDms(this.degrees, this.minutes, DecimalUtils.round(this.seconds, secondsScale));
    }

    public int getDegrees() {
        return this.degrees;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public double getSeconds() {
        return this.seconds;
    }

    public String toString() {
        return String.format("%d\u00b0 %d' %f\"", this.degrees, this.minutes, this.seconds);
    }

    public String toString(Direction direction) {
        return String.format("%s %s", this.toString(), direction.symbol());
    }

    public static GeoDms valueOf(double degree) {
        degree = Math.abs(degree);
        int d = (int)degree;
        int m = (int)((degree - (double)d) * 60.0);
        double s = degree * 3600.0 - (double)(d * 3600) - (double)(m * 60);
        return new GeoDms(d, m, s);
    }
}

