/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.geo;

import com.appslandia.common.utils.AssertUtils;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;

public enum Direction {
    NORTH("N"),
    EAST("E"),
    SOUTH("S"),
    WEST("W");

    final String symbol;
    static final Direction[] DIRECTIONS;

    private Direction(String symbol) {
        this.symbol = symbol;
    }

    public String symbol() {
        return this.symbol;
    }

    public boolean isHorizontal() {
        return this == EAST || this == WEST;
    }

    public boolean isVertical() {
        return this == NORTH || this == SOUTH;
    }

    public Direction reverse() {
        return this.turn(2);
    }

    public Direction right() {
        return this.turn(1);
    }

    public Direction left() {
        return this.turn(-1);
    }

    public Direction turn(int n) {
        if (n == 0) {
            return this;
        }
        int next = (this.ordinal() + n) % 4;
        if (next < 0) {
            next = (next + 4) % 4;
        }
        return DIRECTIONS[next];
    }

    public static Direction parseValue(String symbol) {
        AssertUtils.assertNotNull(symbol);
        switch (symbol = symbol.toUpperCase(Locale.ENGLISH)) {
            case "N": {
                return NORTH;
            }
            case "E": {
                return EAST;
            }
            case "S": {
                return SOUTH;
            }
            case "W": {
                return WEST;
            }
        }
        throw new IllegalArgumentException("symbol is invalid (value=" + symbol + ")");
    }

    public static Direction random() {
        int ordinial = ThreadLocalRandom.current().nextInt(4);
        return DIRECTIONS[ordinial];
    }

    static {
        DIRECTIONS = Direction.values();
    }
}

