/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.DateFormatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import java.util.Date;

public class SqlDateFormatter
extends DateFormatter {
    public static final String ERROR_MSG_KEY = SqlDateFormatter.class.getName() + ".message";

    public SqlDateFormatter() {
        super(false);
    }

    public SqlDateFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return java.sql.Date.class;
    }

    @Override
    protected String getLocalizedPattern(FormatProvider formatProvider) {
        return formatProvider.getLanguage().getPatternDate();
    }

    @Override
    protected String getIsoPattern() {
        return "yyyy-MM-dd";
    }

    @Override
    public java.sql.Date parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        Date d = this.doParse(str, formatProvider);
        return d != null ? new java.sql.Date(d.getTime()) : null;
    }
}

