/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.DecimalUtils;
import com.appslandia.common.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

public class RoundedDoubleFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = RoundedDoubleFormatter.class.getName() + ".message";
    final int scale;
    final RoundingMode roundingMode;

    public RoundedDoubleFormatter(int scale, RoundingMode roundingMode) {
        super(false);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public RoundedDoubleFormatter(int scale, RoundingMode roundingMode, boolean localized) {
        super(localized);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Double.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getDecimalFormat();
    }

    @Override
    public Double parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            if (number instanceof BigDecimal) {
                double value = ((BigDecimal)number).setScale(this.scale, this.roundingMode).doubleValue();
                return DecimalUtils.fixSign(value, number.doubleValue());
            }
            return DecimalUtils.round(number.doubleValue(), this.scale, this.roundingMode);
        }
        try {
            double value = Double.parseDouble(str);
            return DecimalUtils.round(value, this.scale, this.roundingMode);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

