/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;

public class RoundedBigDecimalFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = RoundedBigDecimalFormatter.class.getName() + ".message";
    final int scale;
    final RoundingMode roundingMode;

    public RoundedBigDecimalFormatter(int scale, RoundingMode roundingMode) {
        super(false);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    public RoundedBigDecimalFormatter(int scale, RoundingMode roundingMode, boolean localized) {
        super(localized);
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return BigDecimal.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getDecimalFormat();
    }

    @Override
    public BigDecimal parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            if (number instanceof BigDecimal) {
                return ((BigDecimal)number).setScale(this.scale, this.roundingMode);
            }
            return new BigDecimal(number.toString()).setScale(this.scale, this.roundingMode);
        }
        try {
            return new BigDecimal(str).setScale(this.scale, this.roundingMode);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

