/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.text.NumberFormat;

public class LongFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = LongFormatter.class.getName() + ".message";

    public LongFormatter() {
        super(false);
    }

    public LongFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Long.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getIntegerFormat();
    }

    @Override
    public Long parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            if (number instanceof Long) {
                return (Long)number;
            }
            return number.longValue();
        }
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

