/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Out;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.KeywordUtils;
import com.appslandia.common.utils.StringUtils;

public class KeywordsFormatter
implements Formatter {
    public static final String ERROR_MSG_KEY = KeywordsFormatter.class.getName() + ".message";

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return String.class;
    }

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        return (String)obj;
    }

    @Override
    public String parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        Out<Boolean> isValid = new Out<Boolean>();
        String keywords = KeywordUtils.toKeywords(str, isValid);
        if (!isValid.val().booleanValue()) {
            throw new FormatterException("keywords is invalid format (keywords=" + str + ")", this.getErrorMsgKey());
        }
        return keywords;
    }
}

