/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.ValueUtils;
import java.text.NumberFormat;

public class IntegerFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = IntegerFormatter.class.getName() + ".message";

    public IntegerFormatter() {
        super(false);
    }

    public IntegerFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Integer.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getIntegerFormat();
    }

    @Override
    public Integer parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            long value = number.longValue();
            if (!ValueUtils.isIntRange(value)) {
                throw this.toNumberOverflowError(str);
            }
            return (int)value;
        }
        try {
            long value = Long.parseLong(str);
            if (!ValueUtils.isIntRange(value)) {
                throw this.toNumberOverflowError(str);
            }
            return (int)value;
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

