/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.InitializeObject;
import com.appslandia.common.formatters.BigDecimalFormatter;
import com.appslandia.common.formatters.BooleanFormatter;
import com.appslandia.common.formatters.ByteFormatter;
import com.appslandia.common.formatters.DbTagsFormatter;
import com.appslandia.common.formatters.DoubleFormatter;
import com.appslandia.common.formatters.FloatFormatter;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.IntegerFormatter;
import com.appslandia.common.formatters.KeywordsFormatter;
import com.appslandia.common.formatters.LUCStringFormatter;
import com.appslandia.common.formatters.LocalDateFormatter;
import com.appslandia.common.formatters.LocalDateTimeFormatter;
import com.appslandia.common.formatters.LocalDateTimeMFormatter;
import com.appslandia.common.formatters.LocalTimeFormatter;
import com.appslandia.common.formatters.LocalTimeMFormatter;
import com.appslandia.common.formatters.LongFormatter;
import com.appslandia.common.formatters.OffsetDateTimeFormatter;
import com.appslandia.common.formatters.OffsetDateTimeMFormatter;
import com.appslandia.common.formatters.OffsetTimeFormatter;
import com.appslandia.common.formatters.OffsetTimeMFormatter;
import com.appslandia.common.formatters.ShortFormatter;
import com.appslandia.common.formatters.SqlDateFormatter;
import com.appslandia.common.formatters.SqlTimeFormatter;
import com.appslandia.common.formatters.SqlTimeMFormatter;
import com.appslandia.common.formatters.SqlTimestampFormatter;
import com.appslandia.common.formatters.SqlTimestampMFormatter;
import com.appslandia.common.formatters.StringFormatter;
import com.appslandia.common.formatters.TagFormatter;
import com.appslandia.common.formatters.TagsFormatter;
import com.appslandia.common.formatters.TextFormatter;
import com.appslandia.common.formatters.TextMLFormatter;
import com.appslandia.common.formatters.YearMonthFormatter;
import com.appslandia.common.utils.TypeUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;

public class FormatterProvider
extends InitializeObject {
    private Map<String, Formatter> formatterMap = new HashMap<String, Formatter>();
    private static volatile FormatterProvider __default;
    private static final Object MUTEX;
    private static Supplier<FormatterProvider> __provider;

    @Override
    protected void init() throws Exception {
        this.addDefault("Byte", new ByteFormatter());
        this.addDefault("Short", new ShortFormatter());
        this.addDefault("ShortL", new ShortFormatter(true));
        this.addDefault("Integer", new IntegerFormatter());
        this.addDefault("IntegerL", new IntegerFormatter(true));
        this.addDefault("Long", new LongFormatter());
        this.addDefault("LongL", new LongFormatter(true));
        this.addDefault("Float", new FloatFormatter());
        this.addDefault("FloatL", new FloatFormatter(true));
        this.addDefault("Double", new DoubleFormatter());
        this.addDefault("DoubleL", new DoubleFormatter(true));
        this.addDefault("BigDecimal", new BigDecimalFormatter());
        this.addDefault("BigDecimalL", new BigDecimalFormatter(true));
        this.addDefault("Time", new SqlTimeFormatter());
        this.addDefault("TimeM", new SqlTimeMFormatter());
        this.addDefault("Date", new SqlDateFormatter());
        this.addDefault("DateL", new SqlDateFormatter(true));
        this.addDefault("Timestamp", new SqlTimestampFormatter());
        this.addDefault("TimestampL", new SqlTimestampFormatter(true));
        this.addDefault("TimestampM", new SqlTimestampMFormatter());
        this.addDefault("TimestampML", new SqlTimestampMFormatter(true));
        this.addDefault("Boolean", new BooleanFormatter());
        this.addDefault("String", new StringFormatter());
        this.addDefault("StringEUC", new LUCStringFormatter(false, Locale.ENGLISH));
        this.addDefault("StringELC", new LUCStringFormatter(true, Locale.ENGLISH));
        this.addDefault("Text", new TextFormatter());
        this.addDefault("TextML", new TextMLFormatter());
        this.addDefault("Tag", new TagFormatter());
        this.addDefault("Tags", new TagsFormatter());
        this.addDefault("DbTags", new DbTagsFormatter());
        this.addDefault("Keywords", new KeywordsFormatter());
        this.addDefault("LocalTime", new LocalTimeFormatter());
        this.addDefault("LocalTimeM", new LocalTimeMFormatter());
        this.addDefault("LocalDate", new LocalDateFormatter());
        this.addDefault("LocalDateL", new LocalDateFormatter(true));
        this.addDefault("LocalDateTime", new LocalDateTimeFormatter());
        this.addDefault("LocalDateTimeL", new LocalDateTimeFormatter(true));
        this.addDefault("LocalDateTimeM", new LocalDateTimeMFormatter());
        this.addDefault("LocalDateTimeML", new LocalDateTimeMFormatter(true));
        this.addDefault("OffsetTime", new OffsetTimeFormatter());
        this.addDefault("OffsetTimeM", new OffsetTimeMFormatter());
        this.addDefault("OffsetDateTime", new OffsetDateTimeFormatter());
        this.addDefault("OffsetDateTimeL", new OffsetDateTimeFormatter(true));
        this.addDefault("OffsetDateTimeM", new OffsetDateTimeMFormatter());
        this.addDefault("OffsetDateTimeML", new OffsetDateTimeMFormatter(true));
        this.addDefault("YearMonth", new YearMonthFormatter());
        this.addDefault("YearMonthL", new YearMonthFormatter(true));
        this.formatterMap = Collections.unmodifiableMap(this.formatterMap);
    }

    protected void addDefault(String formatterId, Formatter formatter) {
        if (!this.formatterMap.containsKey(formatterId)) {
            this.formatterMap.put(formatterId, formatter);
        }
    }

    public void addFormatter(String formatterId, Formatter formatter) {
        this.assertNotInitialized();
        this.formatterMap.put(formatterId, formatter);
    }

    public Formatter findFormatter(String formatterId, Class<?> targetType) {
        this.initialize();
        if (formatterId != null) {
            return this.getFormatter(formatterId);
        }
        return this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
    }

    public Formatter getFormatter(Class<?> targetType) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(TypeUtils.wrap(targetType).getSimpleName());
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is not found (targetType=" + targetType + ")");
        }
        return formatter;
    }

    public Formatter getFormatter(String formatterId) throws IllegalArgumentException {
        this.initialize();
        Formatter formatter = this.formatterMap.get(formatterId);
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter is not found (formatterId=" + formatterId + ")");
        }
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormatterProvider getDefault() {
        FormatterProvider obj = __default;
        if (obj == null) {
            Object object = MUTEX;
            synchronized (object) {
                obj = __default;
                if (obj == null) {
                    __default = obj = FormatterProvider.initFormatterProvider();
                }
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(FormatterProvider impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __default = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("FormatterProvider.__default must be null.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProvider(Supplier<FormatterProvider> impl) {
        if (__default == null) {
            Object object = MUTEX;
            synchronized (object) {
                if (__default == null) {
                    __provider = impl;
                    return;
                }
            }
        }
        throw new IllegalStateException("FormatterProvider.__default must be null.");
    }

    private static FormatterProvider initFormatterProvider() {
        if (__provider != null) {
            return __provider.get();
        }
        return new FormatterProvider();
    }

    static {
        MUTEX = new Object();
    }
}

