/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;

public interface Formatter {
    public static final String BYTE = "Byte";
    public static final String SHORT = "Short";
    public static final String SHORT_L = "ShortL";
    public static final String INTEGER = "Integer";
    public static final String INTEGER_L = "IntegerL";
    public static final String LONG = "Long";
    public static final String LONG_L = "LongL";
    public static final String FLOAT = "Float";
    public static final String FLOAT_L = "FloatL";
    public static final String DOUBLE = "Double";
    public static final String DOUBLE_L = "DoubleL";
    public static final String BIGDECIMAL = "BigDecimal";
    public static final String BIGDECIMAL_L = "BigDecimalL";
    public static final String TIME = "Time";
    public static final String TIME_M = "TimeM";
    public static final String DATE = "Date";
    public static final String DATE_L = "DateL";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TIMESTAMP_L = "TimestampL";
    public static final String TIMESTAMP_M = "TimestampM";
    public static final String TIMESTAMP_ML = "TimestampML";
    public static final String LOCAL_TIME = "LocalTime";
    public static final String LOCAL_TIME_M = "LocalTimeM";
    public static final String LOCAL_DATE = "LocalDate";
    public static final String LOCAL_DATE_L = "LocalDateL";
    public static final String LOCAL_DATETIME = "LocalDateTime";
    public static final String LOCAL_DATETIME_L = "LocalDateTimeL";
    public static final String LOCAL_DATETIME_M = "LocalDateTimeM";
    public static final String LOCAL_DATETIME_ML = "LocalDateTimeML";
    public static final String OFFSET_TIME = "OffsetTime";
    public static final String OFFSET_TIME_M = "OffsetTimeM";
    public static final String OFFSET_DATETIME = "OffsetDateTime";
    public static final String OFFSET_DATETIME_L = "OffsetDateTimeL";
    public static final String OFFSET_DATETIME_M = "OffsetDateTimeM";
    public static final String OFFSET_DATETIME_ML = "OffsetDateTimeML";
    public static final String YEAR_MONTH = "YearMonth";
    public static final String YEAR_MONTH_L = "YearMonthL";
    public static final String BOOLEAN = "Boolean";
    public static final String STRING = "String";
    public static final String STRING_EUC = "StringEUC";
    public static final String STRING_ELC = "StringELC";
    public static final String TEXT = "Text";
    public static final String TEXT_ML = "TextML";
    public static final String TAG = "Tag";
    public static final String TAGS = "Tags";
    public static final String DB_TAGS = "DbTags";
    public static final String KEYWORDS = "Keywords";

    default public String getErrorMsgKey() {
        return this.getClass().getName() + ".message";
    }

    public Class<?> getArgType();

    public String format(Object var1, FormatProvider var2);

    public Object parse(String var1, FormatProvider var2) throws FormatterException;

    default public FormatterException toParsingError(String str) {
        return this.toParsingError(str, this.getArgType().getName());
    }

    default public FormatterException toParsingError(String str, String target) {
        return new FormatterException("An error occurred while parsing '" + str + "' to " + target, this.getErrorMsgKey());
    }

    default public FormatterException toNumberOverflowError(String str) {
        return new FormatterException("An overflow occurred while parsing '" + str + "' to " + this.getArgType().getName(), this.getErrorMsgKey());
    }
}

