/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.ValueUtils;
import java.text.NumberFormat;

public class FloatFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = FloatFormatter.class.getName() + ".message";

    public FloatFormatter() {
        super(false);
    }

    public FloatFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Float.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getDecimalFormat();
    }

    @Override
    public Float parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            double value = number.doubleValue();
            if (!ValueUtils.isFloatRange(value)) {
                throw this.toNumberOverflowError(str);
            }
            return Float.valueOf((float)value);
        }
        try {
            double value = Double.parseDouble(str);
            if (!ValueUtils.isFloatRange(value)) {
                throw this.toNumberOverflowError(str);
            }
            return Float.valueOf((float)value);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

