/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.AssertUtils;
import com.appslandia.common.utils.StringUtils;
import java.util.Locale;

public class EnumFormatter<T extends Enum<T>>
implements Formatter {
    final Class<T> type;

    public EnumFormatter(Class<T> type) {
        this.type = AssertUtils.assertNotNull(type);
    }

    @Override
    public Class<?> getArgType() {
        return this.type;
    }

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        return obj.toString();
    }

    public T parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        try {
            return Enum.valueOf(this.type, str.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException ex) {
            throw this.toParsingError(str);
        }
    }
}

