/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.formatters.NumberFormatter;
import com.appslandia.common.utils.StringUtils;
import java.text.NumberFormat;

public class DoubleFormatter
extends NumberFormatter {
    public static final String ERROR_MSG_KEY = DoubleFormatter.class.getName() + ".message";

    public DoubleFormatter() {
        super(false);
    }

    public DoubleFormatter(boolean localized) {
        super(localized);
    }

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return Double.class;
    }

    @Override
    protected NumberFormat getLocalizedFormat(FormatProvider formatProvider) {
        return formatProvider.getDecimalFormat();
    }

    @Override
    public Double parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        if (this.localized) {
            Number number = this.parseNumber(str, formatProvider);
            if (number instanceof Double) {
                return (Double)number;
            }
            return number.doubleValue();
        }
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException ex) {
            throw this.toParsingError(str);
        }
    }
}

