/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.base.Out;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import com.appslandia.common.utils.StringUtils;
import com.appslandia.common.utils.TagUtils;
import java.util.List;

public class DbTagsFormatter
implements Formatter {
    public static final String ERROR_MSG_KEY = DbTagsFormatter.class.getName() + ".message";

    @Override
    public String getErrorMsgKey() {
        return ERROR_MSG_KEY;
    }

    @Override
    public Class<?> getArgType() {
        return String.class;
    }

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        return TagUtils.toDispTags((String)obj);
    }

    @Override
    public String parse(String str, FormatProvider formatProvider) throws FormatterException {
        if ((str = StringUtils.trimToNull(str)) == null) {
            return null;
        }
        Out<Boolean> isValid = new Out<Boolean>();
        List<String> tags = TagUtils.toTags(str, isValid);
        if (!isValid.val().booleanValue()) {
            throw this.toParsingError(str, "DbTags");
        }
        return !tags.isEmpty() ? TagUtils.toDbTags(tags) : null;
    }
}

