/*
 * Decompiled with CFR 0.152.
 */
package com.appslandia.common.formatters;

import com.appslandia.common.base.FormatProvider;
import com.appslandia.common.formatters.Formatter;
import com.appslandia.common.formatters.FormatterException;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;

public abstract class DateFormatter
implements Formatter {
    final boolean localized;

    public DateFormatter(boolean localized) {
        this.localized = localized;
    }

    protected abstract String getLocalizedPattern(FormatProvider var1);

    protected abstract String getIsoPattern();

    @Override
    public String format(Object obj, FormatProvider formatProvider) {
        if (obj == null) {
            return null;
        }
        if (this.localized) {
            return formatProvider.getDateFormat(this.getLocalizedPattern(formatProvider)).format(obj);
        }
        return formatProvider.getDateFormat(this.getIsoPattern()).format(obj);
    }

    protected Date doParse(String str, FormatProvider formatProvider) throws FormatterException {
        DateFormat dateFormat = null;
        dateFormat = this.localized ? formatProvider.getDateFormat(this.getLocalizedPattern(formatProvider)) : formatProvider.getDateFormat(this.getIsoPattern());
        ParsePosition pos = new ParsePosition(0);
        Date parsedValue = dateFormat.parse(str, pos);
        if (pos.getErrorIndex() < 0 && pos.getIndex() == str.length() && parsedValue != null) {
            return parsedValue;
        }
        throw new FormatterException("An error occurred while parsing temporal (str=" + str + ", type=" + this.getArgType() + ")", this.getErrorMsgKey());
    }
}

